% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ensemble_cluster_multi_combinations.R
\name{ensemble_cluster_multi_combinations}
\alias{ensemble_cluster_multi_combinations}
\title{Multi-Method Ensemble Clustering with Multiple Stability Combinations}
\usage{
ensemble_cluster_multi_combinations(
  x,
  k_km,
  k_hc,
  k_sc,
  n_ref = 3,
  B = 100,
  hc.method = "ward.D",
  dist_method = "euclidean",
  alpha = 0.25
)
}
\arguments{
\item{x}{data.frame or matrix where rows are observations and columns are features}

\item{k_km}{number of clusters for k-means clustering}

\item{k_hc}{number of clusters for hierarchical clustering}

\item{k_sc}{number of clusters for spectral clustering}

\item{n_ref}{number of reference distributions for stability assessment (default: 3)}

\item{B}{number of bootstrap samples for stability estimation (default: 100)}

\item{hc.method}{hierarchical clustering method (default: "ward.D")}

\item{dist_method}{distance method for spectral clustering (default: "euclidean")}

\item{alpha}{weight for weighted combination (default: 0.5)}
}
\value{
A list containing results for each combination method:
\describe{
  \item{product}{Results using product combination}
  \item{arithmetic}{Results using arithmetic mean}
  \item{geometric}{Results using geometric mean}
  \item{harmonic}{Results using harmonic mean}
  \item{weighted}{Results using weighted combination}
}
Each method's results contain:
\describe{
  \item{fastgreedy}{Results from fast greedy community detection}
  \item{metis}{Results from METIS (leading eigenvector) community detection}
  \item{hmetis}{Results from hMETIS (Louvain) community detection}
  \item{graph}{igraph object of the ensemble graph}
  \item{edge_weights}{Edge weights of the graph}
  \item{individual_results}{Results from individual clustering methods}
  \item{stability_measures}{Stability measures}
  \item{incidence_matrix}{Incidence matrix used for graph construction}
}
Each community detection method's results contain:
\describe{
  \item{membership}{Final cluster assignments}
  \item{k_consensus}{Number of clusters found}
}
The function also returns comparison statistics for each community detection method:
\describe{
  \item{comparison$fastgreedy}{Comparison stats for fast greedy results}
  \item{comparison$metis}{Comparison stats for METIS results}
  \item{comparison$hmetis}{Comparison stats for hMETIS results}
}
}
\description{
Implements ensemble clustering using multiple methods for combining stability measures,
generating separate consensus results for each combination method.
}
\examples{
\donttest{
data(iris)
df <- iris[,1:4]
results <- ensemble_cluster_multi_combinations(df, k_km=3, k_hc=3, k_sc=3)
# Compare cluster assignments from different methods
table(product = results$product$membership, 
      arithmetic = results$arithmetic$membership)
}

}
