% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3.R
\name{s3_upload_file}
\alias{s3_upload_file}
\title{Upload a file to S3}
\usage{
s3_upload_file(file, uri, content_type = mime_guess(file))
}
\arguments{
\item{file}{string, location of local file}

\item{uri}{string, URI of an S3 object, should start with \code{s3://}, then bucket name and object key}

\item{content_type}{content type of a file that is auto-guess if omitted}
}
\value{
invisibly \code{uri}
}
\description{
Upload a file to S3
}
\examples{
\dontrun{
t <- tempfile()
write.csv(mtcars, t, row.names = FALSE)
s3_upload_file(t, 's3://botor/example-data/mtcars.csv')
unlink(t)
## note that s3_write would have been a much nicer solution for the above
}
}
\references{
\url{https://boto3.amazonaws.com/v1/documentation/api/latest/reference/services/s3.html#S3.Client.upload_file}
}
\seealso{
\code{\link{s3_download_file}}
}
