% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/box_lsp.R
\name{box_use_parser}
\alias{box_use_parser}
\title{'box::use' Document Parser}
\usage{
box_use_parser(expr, action)
}
\arguments{
\item{expr}{An R expression to evaluate}

\item{action}{A list of action functions from \code{languageserver:::parse_expr()}.}
}
\value{
Used for side-effects provided by the \code{action} list of functions.
}
\description{
Custom \{languageserver\} parser hook for \{box\} modules.
}
\examples{
\donttest{
  action <- list(
   assign = function(symbol, value) {
     cat(paste("ASSIGN: ", symbol, value, "\n"))
   },
   update = function(packages) {
     cat(paste("Packages: ", packages, "\n"))
   },
   parse = function(x) {
     cat(paste("Parse: ", names(x), x, "\n"))
   },
   parse_args = function(x) {
     cat(paste("Parse Args: ", names(x), x, "\n"))
   }
 )
  box_use_parser(expr = expression(box::use(fs)), action = action)
}

}
