# Copyright (c) 2023 Merck & Co., Inc., Rahway, NJ, USA and its affiliates.
# All rights reserved.
#
# This file is part of the boxly program.
#
# boxly is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

#' A Subject Level Demographic Dataset
#'
#' A dataset containing the demographic information of a clinical trial following
#' CDISC ADaM standard.
#'
#' Definition of each variable can be found in
#' \url{https://github.com/phuse-org/phuse-scripts/tree/master/data/adam/cdisc}
#'
#' @format A data frame with 254 rows and 51 variables.
#'
#' @source \url{https://github.com/phuse-org/phuse-scripts/tree/master/data/adam/cdisc}
"boxly_adsl"

#' An example ADLB dataset
#'
#' Definition of each variable can be found in
#' \url{https://github.com/phuse-org/phuse-scripts/tree/master/data/adam/cdisc}
#'
#' @format A data frame with 24746 and 24 variables:
#'
#' @source \url{https://github.com/phuse-org/phuse-scripts/tree/master/data/adam/cdisc}
"boxly_adlb"

#' An example ADVS dataset
#'
#' Definition of each variable can be found in
#' \url{https://github.com/phuse-org/phuse-scripts/tree/master/data/adam/cdisc}
#'
#' @format A data frame with 32139 and 34 variables:
#'
#' @source \url{https://github.com/phuse-org/phuse-scripts/tree/master/data/adam/cdisc}
"boxly_advs"

#' An example ADEG dataset
#'
#' Definition of each variable can be found in
#' \url{https://github.com/phuse-org/phuse-scripts/tree/master/data/adam/cdisc}
#' @format A data frame with 32139 and 35 variables:
#'
#' @source \url{https://github.com/phuse-org/phuse-scripts/tree/master/data/adam/cdisc}
"boxly_adeg"
