% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ODRII.R
\name{deviance3}
\alias{deviance3}
\title{Deviance Information Criteria for Ordinal Models
with 3 outcomes}
\usage{
deviance3(y, x, gammacp, p, post_mean_beta, post_std_beta, post_mean_sigma,
  post_std_sigma, beta_draws, sigma_draws, burn, iter)
}
\arguments{
\item{y}{dependent variable i.e. ordinal outcome values.}

\item{x}{covariate matrix of dimension \eqn{(n x k)} including a column of ones.}

\item{gammacp}{row vector of cutpoints including -Inf and Inf.}

\item{p}{quantile level or skewness parameter, p in (0,1).}

\item{post_mean_beta}{mean value of \eqn{\beta} obtained from MCMC draws.}

\item{post_std_beta}{standard deviation of \eqn{\beta} obtained from MCMC draws.}

\item{post_mean_sigma}{mean value of \eqn{\sigma} obtained from MCMC draws.}

\item{post_std_sigma}{standard deviation of \eqn{\sigma} obtained from MCMC draws.}

\item{beta_draws}{MCMC draw of coeffcients, dimension is \eqn{(k x iter)}.}

\item{sigma_draws}{MCMC draw of scale factor, dimension is \eqn{(iter x 1)}.}

\item{burn}{number of discarded MCMC iterations.}

\item{iter}{total number of MCMC iterations including the burn-in.}
}
\value{
Returns a list with components
\deqn{DIC = 2*avgdeviance - devpostmean}
\deqn{pd = avgdeviance - devpostmean}
\deqn{devpostmean = -2*(logLikelihood)}.
}
\description{
Function for computing the Deviance Information Criteria for ordinal
models with 3 outcomes.
}
\details{
The Deviance is -2*(log likelihood) and has an important role in
statistical model comparision because of its relation with Kullback-Leibler
information criteria.
}
\examples{
set.seed(101)
data("data25j3")
x <- data25j3$x
y <- data25j3$y
p <- 0.25
ans <- quan_reg3(y, x, mc = 50, p)
gammacp <- c(-Inf, 0, 4, Inf)
p <- 0.25
post_mean_beta <- ans$post_mean_beta
post_std_beta <- ans$post_std_beta
post_mean_sigma <- ans$post_mean_sigma
post_std_sigma <- ans$post_std_sigma
beta_draws <- ans$beta_draws
sigma_draws <- ans$sigma_draws
mc = 50
burn <- 10
iter <- burn + mc
deviance <- deviance3(y, x, gammacp, p, post_mean_beta, post_std_beta,
post_mean_sigma, post_std_sigma, beta_draws, sigma_draws, burn, iter)

# dic
#   474.4673
# pd
#   5.424001
# devpostmean
#   463.6193

}
\references{
Rahman, M. A. (2016). “Bayesian
Quantile Regression for Ordinal Models.”
Bayesian Analysis, 11(1): 1-24.

Spiegelhalter, D. J., Best, N. G., Carlin B. P. and Linde A. (2002).
“Bayesian Measures of Model Complexity and Fit.” Journal of the
Royal Statistical Society B, Part 4: 583-639.

Gelman, A., Carlin, J. B., Stern, H. S., and Rubin, D. B.
“Bayesian Data Analysis.” 2nd Edition, Chapman and Hall.
}
\seealso{
decision criteria
}
