% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ODRI.R
\name{trace_plotg3}
\alias{trace_plotg3}
\title{Trace Plots for Ordinal Models
with more than 3 outcomes}
\usage{
trace_plotg3(beta_draws, delta_draws)
}
\arguments{
\item{beta_draws}{Gibbs draw of \eqn{\beta} vector of dimension \eqn{(k x iter)}.}

\item{delta_draws}{Gibbs draw of \eqn{\delta}.}
}
\value{
Returns trace plots for each element of \eqn{\beta}
and \eqn{\delta}.
}
\description{
This function generates trace plots of
MCMC samples for \eqn{(\beta ,\delta)} in the quantile
regression model with more than 3 outcomes.
}
\details{
Trace plot is a visual depiction of the values generated from the Markov chain
versus the iteration number.
}
\examples{
set.seed(101)
data("data25j4")
x <- data25j4$x
y <- data25j4$y
p <- 0.25
ans <- quan_regg3(y, x, mc = 50, p, 0.1)
beta_draws <- ans$beta_draws
delta_draws <- ans$delta_draws
trace_plotg3(beta_draws, delta_draws)

}
\references{
Rahman, M. A. (2016). “Bayesian
Quantile Regression for Ordinal Models.”
Bayesian Analysis, 11(1): 1-24.
}
\seealso{
traces in MCMC simulations
}
