% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ORII.R
\name{drawlatentOR2}
\alias{drawlatentOR2}
\title{Samples latent variable z for OR2 model}
\usage{
drawlatentOR2(y, x, beta, sigma, nu, theta, tau2, gammaCp)
}
\arguments{
\item{y}{observed ordinal outcomes, column vector of size \eqn{(n x 1)}.}

\item{x}{covariate matrix of size \eqn{(n x k)} including a column of ones with or without column names.}

\item{beta}{Gibbs draw of \eqn{\beta}, a column vector of size \eqn{(k x 1)}.}

\item{sigma}{\eqn{\sigma}, a scalar value.}

\item{nu}{modified latent weight, column vector of size \eqn{(n x 1)}.}

\item{theta}{(1-2p)/(p(1-p)).}

\item{tau2}{2/(p(1-p)).}

\item{gammaCp}{row vector of cut-points including -Inf and Inf.}
}
\value{
column vector of latent variable z from a univariate truncated distribution.
}
\description{
This function samples the latent variable z from a univariate truncated
normal distribution for OR2 model (ordinal quantile model with exactly 3 outcomes).
}
\details{
This function samples the latent variable z from a univariate truncated normal
distribution.
}
\examples{
set.seed(101)
data("data25j3")
y <- data25j3$y
xMat <- data25j3$x
beta <- c(1.810504, 1.850332, 6.181163)
sigma <- 0.9684741
n <- dim(xMat)[1]
nu <- array(5 * rep(1,n), dim = c(n, 1))
theta <- 2.6667
tau2 <- 10.6667
gammaCp <- c(-Inf, 0, 3, Inf)
output <- drawlatentOR2(y, xMat, beta, sigma, nu,
theta, tau2, gammaCp)

# output
#   1.257096 10.46297 4.138694
#   28.06432 4.179275 19.21582
#   11.17549 13.79059 28.3650 .. soon

}
\references{
Albert, J., and Chib, S. (1993). “Bayesian Analysis of Binary and Polychotomous
Response Data.” Journal of the American Statistical
Association, 88(422): 669–679. DOI: 10.1080/01621459.1993.10476321

Casella, G., and George, E. I. (1992). “Explaining the Gibbs Sampler.”
The American Statistician, 46(3): 167-174. DOI: 10.1080/00031305.1992.10475878

Geman, S., and Geman, D. (1984). “Stochastic Relaxation,
Gibbs Distributions, and the Bayesian Restoration of Images.”
IEEE Transactions an Pattern Analysis and Machine Intelligence,
6(6): 721-741. DOI: 10.1109/TPAMI.1984.4767596

Robert, C. P. (1995). “Simulation of truncated normal variables.” Statistics and
Computing, 5: 121–125. DOI: 10.1007/BF00143942
}
\seealso{
Gibbs sampling, truncated normal distribution,
\link[truncnorm]{rtruncnorm}
}
