% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ORI.R
\name{qrminfundtheorem}
\alias{qrminfundtheorem}
\title{Minimizes the negative of log-likelihood in the OR1 model}
\usage{
qrminfundtheorem(deltaIn, y, x, beta, cri0, cri1, stepsize, maxiter, h, dh, sw, p)
}
\arguments{
\item{deltaIn}{initialization of cut-points.}

\item{y}{observed ordinal outcomes, column vector of size \eqn{(n x 1)}.}

\item{x}{covariate matrix of size \eqn{(n x k)} including a column of ones with or without column names.}

\item{beta}{\eqn{\beta}, a column vector of size \eqn{(k x 1)}.}

\item{cri0}{initial criterion, \eqn{cri0 = 1}.}

\item{cri1}{criterion lies between (0.001 to 0.0001).}

\item{stepsize}{learning rate lies between (0.1, 1).}

\item{maxiter}{maximum number of iteration.}

\item{h}{change in each value of \eqn{\delta}, holding other \eqn{\delta}
constant for first derivatives.}

\item{dh}{change in each value of \eqn{\delta}, holding other \eqn{\delta} constant
for second derivaties.}

\item{sw}{iteration to switch from BHHH to inv(-H) algorithm.}

\item{p}{quantile level or skewness parameter, p in (0,1).}
}
\value{
Returns a list with components
\itemize{
\item{\code{deltamin}: }{cutpoint vector that minimizes the log-likelihood function.}
\item{\code{negsum}: }{negative sum of log-likelihood.}
\item{\code{logl}: }{log-likelihood values.}
\item{\code{G}: }{gradient vector, \eqn{(n x k)} matrix with i-th row as the score
for the i-th unit.}
\item{\code{H}: }{Hessian matrix.}
}
}
\description{
This function minimizes the negative of log-likelihood in the OR1 model
with respect to the cut-points \eqn{\delta} using the
fundamental theorem of calculus.
}
\details{
First derivative from first principle
\deqn{dy/dx=[f(x+h)-f(x-h)]/2h}

Second derivative from first principle

\deqn{f'(x-h)=(f(x)-f(x-h))/h}
\deqn{f''(x)= [{(f(x+h)-f(x))/h} - (f(x)-f(x-h))/h]/h}
      \deqn{= [(f(x+h)+f(x-h)-2 f(x))]/h^2}

cross partial derivatives

\deqn{f(x) = [f(x+dh,y)-f(x-dh,y)]/2dh}
\deqn{f(x,y)=[{(f(x+dh,y+dh) - f(x+dh,y-dh))/2dh} - {(f(x-dh,y+dh) -
f(x-dh,y-dh))/2dh}]/2dh}
\deqn{= 0.25* [{(f(x+dh,y+dh)-f(x+dh,y-dh))} -{(f(x-dh,y+dh)-f(x-dh,y-dh))}]/dh2}
}
\examples{
set.seed(101)
deltaIn <- c(-0.002570995,  1.044481071)
data("data25j4")
y <- data25j4$y
xMat <- data25j4$x
p <- 0.25
beta <- c(0.3990094, 0.8168991, 2.8034963)
cri0     <- 1
cri1     <- 0.001
stepsize <- 1
maxiter  <- 10
h        <- 0.002
dh       <- 0.0002
sw       <- 20
output <- qrminfundtheorem(deltaIn, y, xMat, beta, cri0, cri1, stepsize, maxiter, h, dh, sw, p)

# deltamin
#   0.8266967 0.3635708
# negsum
#   645.4911
# logl
#    -0.7136999
#    -1.5340787
#    -1.1072447
#    -1.4423124
#    -1.3944677
#    -0.7941271
#    -1.6544072
#    -0.3246632
#    -1.8582422
#    -0.9220822
#    -2.1117739 .. soon
# G
#    0.803892784  0.00000000
#   -0.420190546  0.72908381
#   -0.421776117  0.72908341
#   -0.421776117 -0.60184063
#   -0.421776117 -0.60184063
#    0.151489598  0.86175120
#    0.296995920  0.96329114
#   -0.421776117  0.72908341
#   -0.340103190 -0.48530164
#    0.000000000  0.00000000
#   -0.421776117 -0.60184063.. soon
# H
#   -338.21243  -41.10775
#   -41.10775 -106.32758

}
\seealso{
differential calculus, functional maximization,
\link[pracma]{mldivide}
}
