% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/count_interlobar.R
\name{count_interlobar}
\alias{count_interlobar}
\title{Count number of inter-lobar connections from a given major lobe}
\usage{
count_interlobar(g, lobe, atlas.dt)
}
\arguments{
\item{g}{The igraph graph object}

\item{lobe}{A character string indicating the lobe to count from (uppercase)}

\item{atlas.dt}{A data table with specific atlas data}
}
\value{
A data table of total, intra-, and inter-lobar edge counts
}
\description{
This function will count the number of edges between all vertices in one
major lobe (e.g. Frontal) and all other major lobes.
}
\examples{
\dontrun{
atlas.dt <- eval(parse(text=g1[[N]]$atlas))
g1.frontal <- count_interlobar(g1[[N]], 'Frontal', atlas.dt)
}
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}

