% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plot_vertex_measures.R
\name{plot_vertex_measures}
\alias{plot_vertex_measures}
\title{Plot vertex-level graph measures at a single density}
\usage{
plot_vertex_measures(dat, cur.density = 0.1, measure = "btwn.cent",
  ylabel = NULL)
}
\arguments{
\item{dat}{A ``tidied'' data table of vertex-level graph measures}

\item{cur.density}{A numeric indicating the graph density}

\item{measure}{A character string of the graph measure to plot (default:
'btwn.cent')}

\item{ylabel}{A character string for the y-axis label}
}
\value{
A \code{ggplot} object
}
\description{
This function creates boxplots of a single vertex-level graph measure at a
single density, grouped by \emph{lobe}; each lobe has a separate \emph{facet}
in a \code{ggplot} object.
}
\examples{
\dontrun{
ggp.btwn <- plot_vertex_measures(net.meas.tidy, densities[N], 'btwn.cent')
}
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}

