% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/individ_contrib.R
\name{IndividualContributions}
\alias{IndividualContributions}
\alias{loo}
\alias{aop}
\title{Approaches to estimate individual network contribution}
\usage{
loo(resids, corrs, level = c("global", "regional"))

aop(resids, index, corr.mat, level = c("global", "regional"))
}
\arguments{
\item{resids}{Data table of model residuals}

\item{corrs}{List of lists of correlation matrices (as output by
\code{\link{corr.matrix}}).}

\item{level}{Character string; the level at which you want to calculate
contributions (either \code{global} or \code{regional})}

\item{index}{Integer; the row number (in \code{resids}) of the subject to be
added}

\item{corr.mat}{Numeric; correlation matrix of the \emph{control} group}
}
\value{
A \code{data.table} with columns for
  \item{Study.ID}{Subject identifier}
  \item{Group}{Group membership}
  \item{IC}{The value of the individual contribution}
}
\description{
\code{loo} calculates the individual contribution to group network data for
each subject in each group using a "leave-one-out" approach. The residuals of
a single subject are excluded, and a correlation matrix is created. This is
compared to the original correlation matrix using the Mantel test.

\code{aop} calculates the individual contribution using an "add-one-patient"
approach. The residuals of a single patient are added to those of a control
group, and a correlation matrix is created.
}
\examples{
\dontrun{
IC <- loo(resids.all, corrs)
RC <- loo(resids.all, corrs, level='regional')
}
\dontrun{
IC <- adply(which(resids.all[, Group == groups[2]]), .margins=1, function(x)
            aop(resids.all, x, corrs[[1]][[1]]$R),
            .parallel=T, .id=NULL)
}
}
\references{
Saggar M., Hosseini S.M.H., Buno J.L., Quintin E., Raman M.M.,
  Kesler S.R., Reiss A.L. (2015) \emph{Estimating individual contributions
  from group-based structural correlations networks}. NeuroImage, 120:274-284.
  doi:10.1016/j.neuroimage.2015.07.006
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
