% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/small_world.R
\name{small.world}
\alias{small.world}
\title{Calculate graph small-worldness}
\usage{
small.world(g.list, rand)
}
\arguments{
\item{g.list}{A \code{brainGraphList} object or list of graphs}

\item{rand}{List of (lists of) equivalent random graphs (output from
\code{\link{sim.rand.graph.par}})}
}
\value{
A \code{data.table} with the following components:
\item{density}{The range of density thresholds used.}
\item{N}{The number of random graphs that were generated.}
\item{Lp,Lp.rand,Lp.norm}{The observed, average random, and normalized
  characteristic path length.}
\item{Cp,Cp.rand,Cp.norm}{The observed, average random, and normalized
  clustering coefficient.}
\item{sigma}{The small-world measure of the graph.}
}
\description{
\code{small.world} calculates the normalizaed characteristic path length and
clustering coefficient based on observed and random graphs, used to calculate
the small-world coefficient \eqn{\sigma}.
}
\references{
Watts, D.J. and Strogatz S.H. (1998) Collective dynamics of
  "small-world" networks. \emph{Nature}, \bold{393}, 440--442.
  \url{https://dx.doi.org/10.1515/9781400841356.301}
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
