% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_brainGraph_attributes.R
\name{set_brainGraph_attr}
\alias{set_brainGraph_attr}
\title{Set graph, vertex, and edge attributes common in MRI analyses}
\usage{
set_brainGraph_attr(g, atlas = NULL, rand = FALSE,
  use.parallel = TRUE, A = NULL, xfm.type = c("1/w", "-log(w)",
  "1-w"), clust.method = "louvain", ...)
}
\arguments{
\item{g}{An \code{igraph} graph object}

\item{atlas}{Character vector indicating which atlas was used (default:
\code{NULL})}

\item{rand}{Logical indicating if the graph is random or not (default:
\code{FALSE})}

\item{use.parallel}{Logical indicating whether or not to use \emph{foreach}
(default: \code{TRUE})}

\item{A}{Numeric matrix; the (weighted) adjacency matrix, which can be used
for faster calculation of local efficiency (default: \code{NULL})}

\item{xfm.type}{Character string indicating how to transform edge weights
(default: \code{1/w} [reciprocal])}

\item{clust.method}{Character string indicating which method to use for
community detection. Default: \code{'louvain'}}

\item{...}{Other arguments passed to \code{\link{make_brainGraph}}}
}
\value{
g An \code{igraph} graph object with the following attributes:
  \item{Graph-level}{Density, connected component sizes, diameter, \# of
    triangles, transitivity, average path length, assortativity, global &
    local efficiency, modularity, vulnerability, hub score, rich-club
    coefficient, \# of hubs, edge asymmetry, and modality}
  \item{Vertex-level}{Degree, strength; betweenness, eigenvector, and
    leverage centralities; hubs; transitivity (local); k-core, s-core; local
    & nodal efficiency; color (community, lobe, component); membership
    (community, lobe, component); gateway and participation coefficients,
    within-module degree z-score; vulnerability; and coordinates (x, y, and
    z)}
  \item{Edge-level}{Color (community, lobe, component), edge betweenness,
    Euclidean distance (in mm), weight (if weighted)}
}
\description{
This function sets a number of graph, vertex, and edge attributes for a
given \code{igraph} graph object. These are all measures that are common in
MRI analyses of brain networks.
}
\details{
\code{xfm.type} allows you to choose from 3 options for transforming edge
weights when calculating distance-based metrics (e.g., shortest paths). There
is no "best-practice" for choosing one over the other, but the reciprocal is
probably most common.
\itemize{
  \item \code{1/w}: reciprocal (default)
  \item \code{-log(w)}: the negative (natural) logarithm
  \item \code{1-w}: subtract weights from 1
}

\code{clust.method} allows you to choose from any of the clustering
(community detection) functions available in \code{igraph}. These functions
all begin with \code{clust_}; the function argument should not include this
leading character string. The default value is \code{louvain}, which calls
\code{\link[igraph]{cluster_louvain}}. If there are any negative edge
weights, and the selected method is anything other than \code{spinglass} or
\code{walktrap}, then \code{walktrap} is used (calling
\code{\link[igraph]{cluster_walktrap}}). If \code{edge_betweenness} is
selected and the graph is weighted, then the edges are first transformed (via
\code{\link{xfm.weights}}), because the algorithm considers edges as
\emph{distances}.

Since \code{v2.4.0}, hubs are calculated by the new function
\code{\link{hubness}}. It is calculated using edge weights in addition to the
unweighted version of the graph.
}
\seealso{
\code{\link[igraph]{components}}, \code{\link[igraph]{diameter}},
\code{\link[igraph]{clique_num}}, \code{\link[igraph]{centr_betw}},
\code{\link{part_coeff}}, \code{\link[igraph]{edge.betweenness}},
\code{\link[igraph]{centr_eigen}}, \code{\link{gateway_coeff}},
\code{\link[igraph]{transitivity}}, \code{\link[igraph]{mean_distance}},
\code{\link[igraph]{assortativity_degree}}, \code{\link{efficiency}},
\code{\link[igraph]{assortativity_nominal}}, \code{\link[igraph]{coreness}},
\code{\link[igraph]{communities}}, \code{\link{set_edge_color}},
\code{\link{rich_club_coeff}}, \code{\link{s_core}}, \code{\link{centr_lev}},
\code{\link{within_module_deg_z_score}}, \code{\link{edge_spatial_dist}},
\code{\link{vulnerability}}, \code{\link{edge_asymmetry}},
\code{\link[igraph]{graph.knn}}, \code{\link{vertex_spatial_dist}}
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
