% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetch_data.R
\name{fetch_data}
\alias{fetch_data}
\title{Fetch zonal statistics}
\usage{
fetch_data(code_muni, product, indicator, statistics, date_start, date_end)
}
\arguments{
\item{code_muni}{numeric. IBGE municipality code number with 7 digits.}

\item{product}{string. Zonal indicator product. Options are: \code{brdwgd}, \code{terraclimate}.}

\item{indicator}{string. Indicator name from the product. Check the available indicators with the \link{product_info} function.}

\item{statistics}{string. Statistics name from the indicator. Check the available statistics with the \link{product_info} function.}

\item{date_start}{date, included in the selection.}

\item{date_end}{date, included in the selection, must be equal or greater than \code{date_start}.}
}
\value{
A \code{data.frame} with date and value columns.
}
\description{
Fetch zonal statistics from a product for given municipality code and dates.
}
\details{
For products with monthly data, like \code{terraclimate}, inform the start and end dates with the fist day of the month. Example: \code{as.Date("2008-06-01")} for June, 2008.
}
\examples{
\donttest{
fetch_data(
    code_muni = 3304557,
    product = "brdwgd",
    indicator = "tmax",
    statistics = "mean",
    date_start = as.Date("2008-01-01"),
    date_end = as.Date("2008-01-10")
 )
 }
}
