% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/richness_objective_bayes.R
\name{objective_bayes_poisson}
\alias{objective_bayes_poisson}
\title{Objective Bayes species richness estimate with the Poisson model}
\usage{
objective_bayes_poisson(
  data,
  output = TRUE,
  plot = TRUE,
  answers = FALSE,
  tau = 10,
  burn.in = 100,
  iterations = 2500,
  Metropolis.stdev.N = 75,
  Metropolis.start.lambda = 1,
  Metropolis.stdev.lambda = 0.3
)
}
\arguments{
\item{data}{A frequency count table}

\item{output}{Print summary of fitted model. Default is TRUE.}

\item{plot}{Plot estimates? Default is TRUE.}

\item{answers}{Return dataframe containing model summaries? Default is FALSE.}

\item{tau}{Truncation cutoff for model fitting. (Counts above this cutoff
are not used in model fitting.) Default is 10.}

\item{burn.in}{Number of MCMC burn-in iterations. Default is 100.}

\item{iterations}{Number of MCMC iterations after burn-in. Default is 2500.}

\item{Metropolis.stdev.N}{Standard deviation of proposal distribution
parameter N within MCMC. Default is 75.}

\item{Metropolis.start.lambda}{Starting value of parameter lambda.
Default is 1}

\item{Metropolis.stdev.lambda}{Standard deviation of proposal distribution
parameter T1 within MCMC. Default is 0.3.}
}
\value{
If answers set to TRUE, a dataframe containing posterior median and
95\% posterior credible intervals for richness, fitted values, and
MCMC diagnostics. If answers set to FALSE (default), no value is returned.
}
\description{
Objective Bayes species richness estimate with the Poisson model
}
