% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brnb.R
\name{vcov.brnb}
\alias{vcov.brnb}
\title{Extract model variance-covariance matrix from \code{\link{brnb}} objects}
\usage{
\method{vcov}{brnb}(object, model = c("mean", "full", "dispersion"), complete = TRUE, ...)
}
\arguments{
\item{object}{an object of class "brnb", usually, a result of a call to \code{\link{brnb}}.}

\item{model}{character specifying for which component of the model variance-covariance matrix should be extracted.}

\item{complete}{for the \code{aov}, \code{lm}, \code{glm}, \code{mlm}, and where
    applicable \code{summary.lm} etc methods: logical indicating if the
    full variance-covariance matrix should be returned also in case of
    an over-determined system where some coefficients are undefined and
    \code{\link[stats]{coef}(.)} contains \code{NA}s correspondingly.   When
    \code{complete = TRUE},  \code{vcov()} is compatible with
    \code{coef()} also in this singular case.}

\item{...}{
    additional arguments for method functions.  For the
    \code{\link[stats]{glm}} method this can be used to pass a
    \code{dispersion} parameter.}
}
\description{
Extract model variance-covariance matrix from \code{\link{brnb}} objects
}
\details{
The options for \code{model} are \code{"mean"} for mean regression
 only (default), \code{"dispersion"} for the dispersion
parameter (in a chosen transformation; see
\code{\link{brglmControl}}), and \code{"full"} for both the mean
regression and the (transformed) dispersion parameters.
See \code{\link{vcov}} for more details.
}
\seealso{
\code{\link{vcov}}
}
