% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workspaces.R
\name{db_workspace_import}
\alias{db_workspace_import}
\title{Import Notebook/Directory (Workspaces)}
\usage{
db_workspace_import(
  path,
  file = NULL,
  content = NULL,
  format = c("AUTO", "SOURCE", "HTML", "JUPYTER", "DBC", "R_MARKDOWN"),
  language = NULL,
  overwrite = FALSE,
  host = db_host(),
  token = db_token(),
  perform_request = TRUE
)
}
\arguments{
\item{path}{Absolute path of the notebook or directory.}

\item{file}{Path of local file to upload. See \code{formats} parameter.}

\item{content}{Content to upload, this will be base64-encoded and has a limit
of 10MB.}

\item{format}{One of \code{AUTO}, \code{SOURCE}, \code{HTML}, \code{JUPYTER}, \code{DBC}, \code{R_MARKDOWN}.
Default is \code{SOURCE}.}

\item{language}{One of \code{R}, \code{PYTHON}, \code{SCALA}, \code{SQL}. Required when \code{format}
is \code{SOURCE} otherwise ignored.}

\item{overwrite}{Flag that specifies whether to overwrite existing object.
\code{FALSE} by default. For \code{DBC} overwrite is not supported since it may contain
a directory.}

\item{host}{Databricks workspace URL, defaults to calling \code{\link[=db_host]{db_host()}}.}

\item{token}{Databricks workspace token, defaults to calling \code{\link[=db_token]{db_token()}}.}

\item{perform_request}{If \code{TRUE} (default) the request is performed, if
\code{FALSE} the httr2 request is returned \emph{without} being performed.}
}
\description{
Import a notebook or the contents of an entire directory.
}
\details{
\code{file} and \code{content} are mutually exclusive. If both are specified \code{content}
will be ignored.

If path already exists and \code{overwrite} is set to \code{FALSE}, this call returns
an error \code{RESOURCE_ALREADY_EXISTS.} You can use only \code{DBC} format to import
a directory.
}
\seealso{
Other Workspace API: 
\code{\link{db_workspace_delete}()},
\code{\link{db_workspace_export}()},
\code{\link{db_workspace_get_status}()},
\code{\link{db_workspace_list}()},
\code{\link{db_workspace_mkdirs}()}
}
\concept{Workspace API}
