% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/warehouses.R
\name{get_and_start_warehouse}
\alias{get_and_start_warehouse}
\title{Get and Start Warehouse}
\usage{
get_and_start_warehouse(
  id,
  polling_interval = 5,
  host = db_host(),
  token = db_token()
)
}
\arguments{
\item{id}{ID of the SQL warehouse.}

\item{polling_interval}{Number of seconds to wait between status checks}

\item{host}{Databricks workspace URL, defaults to calling \code{\link[=db_host]{db_host()}}.}

\item{token}{Databricks workspace token, defaults to calling \code{\link[=db_token]{db_token()}}.}
}
\value{
\code{db_sql_warehouse_get()}
}
\description{
Get and Start Warehouse
}
\details{
Get information regarding a Databricks cluster. If the cluster is
inactive it will be started and wait until the cluster is active.
}
\seealso{
\code{\link[=db_sql_warehouse_get]{db_sql_warehouse_get()}} and \code{\link[=db_sql_warehouse_start]{db_sql_warehouse_start()}}.

Other Warehouse API: 
\code{\link{db_sql_global_warehouse_get}()},
\code{\link{db_sql_warehouse_create}()},
\code{\link{db_sql_warehouse_delete}()},
\code{\link{db_sql_warehouse_edit}()},
\code{\link{db_sql_warehouse_get}()},
\code{\link{db_sql_warehouse_list}()},
\code{\link{db_sql_warehouse_start}()},
\code{\link{db_sql_warehouse_stop}()}
}
\concept{Warehouse API}
\concept{Warehouse Helpers}
