% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repos.R
\name{db_repo_update}
\alias{db_repo_update}
\title{Update Repo}
\usage{
db_repo_update(
  repo_id,
  branch = NULL,
  tag = NULL,
  host = db_host(),
  token = db_token(),
  perform_request = TRUE
)
}
\arguments{
\item{repo_id}{The ID for the corresponding repo to access.}

\item{branch}{Branch that the local version of the repo is checked out to.}

\item{tag}{Tag that the local version of the repo is checked out to.}

\item{host}{Databricks workspace URL, defaults to calling \code{\link[=db_host]{db_host()}}.}

\item{token}{Databricks workspace token, defaults to calling \code{\link[=db_token]{db_token()}}.}

\item{perform_request}{If \code{TRUE} (default) the request is performed, if
\code{FALSE} the httr2 request is returned \emph{without} being performed.}
}
\description{
Updates the repo to the given branch or tag.
}
\details{
Specify either \code{branch} or \code{tag}, not both.

Updating the repo to a tag puts the repo in a detached HEAD state.
Before committing new changes, you must update the repo to a branch instead
of the detached HEAD.
}
\seealso{
Other Repos API: 
\code{\link{db_repo_create}()},
\code{\link{db_repo_delete}()},
\code{\link{db_repo_get}()},
\code{\link{db_repo_get_all}()}
}
\concept{Repos API}
