% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pollen-data.R
\name{create.pollen.sources}
\alias{create.pollen.sources}
\title{Pollen sources emission simulation}
\usage{
create.pollen.sources(nbOfSource=200, numberOfDay=60,
density=runif(1,7,11), pollen=rgamma(1,shape=1.6,scale=1/(2*10^-7)))
}
\arguments{
\item{nbOfSource}{Number of source fields}

\item{numberOfDay}{Number of time units (e.g. days) including the pollen emission (for simulation, default is time.max). Minimal value is 12 days.}

\item{density}{Plant density (number of plant by squared meter)}

\item{pollen}{Pollen production (number of grains by plant)}
}
\value{
A matrix indexed by sources ID (in rows) and by time ( in columns) whose rows give the values of pollen emission (number of grains) for every source.
}
\description{
Simulate pollen sources emission for maize crop. The proportion of plants 
emitting pollen per day (during 12 days) was observed by Frédérique Angevin (Angevin et al. 2008).
}
\examples{
# simulation of an emission matrix for 20 emitting sources and a emission period of 15 days:
create.pollen.sources(nbOfSource=20,numberOfDay=15)
# simulation of an emission matrix for 1 emitting source and a emission period of 20 days:
pollen.emission<-create.pollen.sources(nbOfSource=1,numberOfDay=20)
plot(pollen.emission[1,],xlab="time unites",ylab="maize crop emission")
}

