% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brm_formula.R
\name{brm_formula}
\alias{brm_formula}
\title{Model formula}
\usage{
brm_formula(
  data,
  intercept = TRUE,
  effect_base = TRUE,
  effect_group = TRUE,
  effect_time = TRUE,
  interaction_base = TRUE,
  interaction_group = TRUE,
  correlation = "unstructured"
)
}
\arguments{
\item{data}{A classed data frame from \code{\link[=brm_data]{brm_data()}}.}

\item{intercept}{\code{TRUE} to include an intercept, \code{FALSE} to omit.}

\item{effect_base}{\code{TRUE} to include an additive effect for baseline
response, \code{FALSE} to omit.}

\item{effect_group}{\code{TRUE} to include an additive effects for treatment
groups, \code{FALSE} to omit.}

\item{effect_time}{\code{TRUE} to include a additive effect for discrete
time points, \code{FALSE} to omit.}

\item{interaction_base}{\code{TRUE} to include baseline-by-time interaction,
\code{FALSE} to omit.}

\item{interaction_group}{\code{TRUE} to include treatment-group-by-time
interaction, \code{FALSE} to omit.}

\item{correlation}{Character of length 1, name of the correlation
structure. Only \code{"unstructured"} is currently supported.}
}
\value{
An object of class \code{"brmsformula"} returned from
\code{brms::brmsformula()}. It contains the fixed effect parameterization,
correlation structure, and residual variance structure.
}
\description{
Build a model formula for an MMRM.
}
\examples{
set.seed(0)
data <- brm_data(
  data = brm_simulate()$data,
  outcome = "response",
  role = "response",
  group = "group",
  time = "time",
  patient = "patient"
)
brm_formula(data)
brm_formula(data = data, intercept = FALSE, effect_base = FALSE)
brm_formula(
  data = data,
  intercept = FALSE,
  effect_base = FALSE,
  interaction_group = FALSE
)
}
\seealso{
Other models: 
\code{\link{brm_model}()}
}
\concept{models}
