% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/support.export.R
\name{brm.pars}
\alias{brm.pars}
\title{Parameters of interest for \code{brms} models}
\usage{
brm.pars(formula, data = NULL, family = "gaussian", autocor = NULL,
  partial = NULL, threshold = "flexible", ranef = TRUE, WAIC = FALSE,
  predict = FALSE)
}
\arguments{
\item{formula}{An object of class "formula" (or one that can be coerced to that class): a symbolic description of the model to be fitted.
The details of model specification are given under 'Details'.}

\item{data}{An optional data frame, list or environment  (or object coercible by \code{as.data.frame} to a data frame) containing
the variables in the model. If not found in data, the variables are taken from \code{environment(formula)},
typically the environment from which \code{brm} is called.}

\item{family}{A vector of one or two character strings. The first string indicates the distribution of the dependent variable (the 'family'). Currently, the following families are supported:
\code{"gaussian"}, \code{"student"}, \code{"cauchy"}, \code{"multigaussian"}, \code{"binomial"}, \code{"bernoulli"}, \code{"categorical"}, \code{"poisson"}, \code{"negbinomial"}, \cr
\code{"geometric"}, \code{"gamma"}, \code{"exponential"}, \code{"weibull"}, \code{"cumulative"}, \code{"cratio"}, \code{"sratio"}, and \code{"acat"}.
The second string indicates the link function, which must be supported by the distribution of the dependent variable.
If not specified, default link functions are used. Further information is provided under 'Details'.}

\item{autocor}{An optional \code{\link{cor.brms}} object describing the correlation structure within the response variable (i.e. the 'autocorrelation').
See the documentation of \code{\link{cor.brms}} for a description of the available correlation structures.
Defaults to NULL, corresponding to no correlations.}

\item{partial}{A one sided formula of the form \code{~partial.effects} specifing the predictors that can vary between categories in non-cumulative ordinal models
(i.e. in families \code{"cratio"}, \code{"sratio"}, or \code{"acat"}).}

\item{threshold}{A character string indicating the type of thresholds (i.e. intercepts) used in an ordinal model.
\code{"flexible"} provides the standard unstructured thresholds and \code{"equidistant"} restricts the distance between consecutive thresholds to the same value.}

\item{ranef}{logical; indicating if random effects estimates should be returned}

\item{WAIC}{A flag to indicate if the log likelihood of the model should be saved so that the WAIC can be computed afterwards.
For models with many observation, this leads to rather huge fitted model objects.}

\item{predict}{A flag to indicate if posterior predictives of the dependent variable should be generated.
For models with many observation, this leads to rather huge fitted model objects.}
}
\value{
A vector of character strings specifying parameters of interest for models produced by the \code{brms} package.
}
\description{
Parameters of interest for \code{brms} models
}
\examples{
brm.pars(rating ~ treat + period + carry + (1|subject),
         data = inhaler, family = "cumulative")
}
\author{
Paul-Christian Buerkner \email{paul.buerkner@gmail.com}
}

