% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_standata.R
\name{make_standata}
\alias{make_standata}
\alias{brmdata}
\title{Data for \pkg{brms} Models}
\usage{
make_standata(formula, data, family = NULL, prior = NULL, autocor = NULL,
  nonlinear = NULL, cov_ranef = NULL, sample_prior = FALSE,
  knots = NULL, control = list(), ...)
}
\arguments{
\item{formula}{An object of class 
\code{\link[stats:formula]{formula}} or
\code{\link[brms:brmsformula]{brmsformula}}
(or one that can be coerced to that classes): 
A symbolic description of the model to be fitted. 
The details of model specification are explained in 
\code{\link[brms:brmsformula]{brmsformula}}.}

\item{data}{An object of class \code{data.frame} 
(or one that can be coerced to that class) 
containing data of all variables used in the model.}

\item{family}{A description of the response distribution and link function 
to be used in the model. This can be a family function, 
a call to a family function or a character string naming the family.
Every family function has a \code{link} argument allowing to specify
the link function to be applied on the response variable.
If not specified, default links are used.
For details of supported families see 
\code{\link[brms:brmsfamily]{brmsfamily}}.
By default, a linear \code{gaussian} model is applied.}

\item{prior}{One or more \code{brmsprior} objects created by
\code{\link[brms:set_prior]{set_prior}} or related functions 
and combined using the \code{c} method. A single \code{brmsprior} 
object may be passed without \code{c()} surrounding it. 
See also  \code{\link[brms:get_prior]{get_prior}} for more help.}

\item{autocor}{An optional \code{\link{cor_brms}} object describing 
the correlation structure within the response variable 
(i.e., the 'autocorrelation'). 
See the documentation of \code{\link{cor_brms}} for a description 
of the available correlation structures. Defaults to \code{NULL}, 
corresponding to no correlations.}

\item{nonlinear}{(Deprecated) An optional list of formulas, specifying 
linear models for non-linear parameters. If \code{NULL} (the default)
\code{formula} is treated as an ordinary formula. 
If not \code{NULL}, \code{formula} is treated as a non-linear model
and \code{nonlinear} should contain a formula for each non-linear 
parameter, which has the parameter on the left hand side and its
linear predictor on the right hand side.
Alternatively, it can be a single formula with all non-linear
parameters on the left hand side (separated by a \code{+}) and a
common linear predictor on the right hand side.
As of \pkg{brms} 1.4.0, we recommend specifying non-linear
parameters directly within \code{formula}.}

\item{cov_ranef}{A list of matrices that are proportional to the 
(within) covariance structure of the group-level effects. 
The names of the matrices should correspond to columns 
in \code{data} that are used as grouping factors. 
All levels of the grouping factor should appear as rownames 
of the corresponding matrix. This argument can be used,
among others to model pedigrees and phylogenetic effects.
See \code{vignette("brms_phylogenetics")} for more details.}

\item{sample_prior}{A flag to indicate if samples from all specified 
proper priors should be drawn additionally to the posterior samples
(defaults to \code{FALSE}). Among others, these samples can be used 
to calculate Bayes factors for point hypotheses. 
Alternatively, \code{sample_prior} can be set to \code{"only"} to
sample solely from the priors. In this case, all parameters must 
have proper priors.}

\item{knots}{Optional list containing user specified knot values to be 
used for basis construction of smoothing terms. 
See \code{\link[mgcv:gamm]{gamm}} for more details.}

\item{control}{A named list currently for internal usage only}

\item{...}{Other potential arguments}
}
\value{
A named list of objects containing the required data 
  to fit a \pkg{brms} model with \pkg{Stan}.
}
\description{
Generate data for \pkg{brms} models to be passed to \pkg{Stan}
}
\examples{
data1 <- make_standata(rating ~ treat + period + carry + (1|subject), 
                       data = inhaler, family = "cumulative")
names(data1)

data2 <- make_standata(count ~ log_Age_c + log_Base4_c * Trt_c 
                       + (1|patient) + (1|visit), 
                       data = epilepsy, family = "poisson")
names(data2)
         
}
\author{
Paul-Christian Buerkner \email{paul.buerkner@gmail.com}
}
