% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictive_error.R
\name{predictive_error.brmsfit}
\alias{predictive_error.brmsfit}
\alias{predictive_error}
\title{Posterior Draws of Predictive Errors}
\usage{
\method{predictive_error}{brmsfit}(
  object,
  newdata = NULL,
  re_formula = NULL,
  re.form = NULL,
  resp = NULL,
  ndraws = NULL,
  draw_ids = NULL,
  sort = FALSE,
  ...
)
}
\arguments{
\item{object}{An object of class \code{brmsfit}.}

\item{newdata}{An optional data.frame for which to evaluate predictions. If
\code{NULL} (default), the original data of the model is used.
\code{NA} values within factors are interpreted as if all dummy
variables of this factor are zero. This allows, for instance, to make
predictions of the grand mean when using sum coding.}

\item{re_formula}{formula containing group-level effects to be considered in
the prediction. If \code{NULL} (default), include all group-level effects;
if \code{NA}, include no group-level effects.}

\item{re.form}{Alias of \code{re_formula}.}

\item{resp}{Optional names of response variables. If specified, predictions
are performed only for the specified response variables.}

\item{ndraws}{Positive integer indicating how many posterior draws should
be used. If \code{NULL} (the default) all draws are used. Ignored if
\code{draw_ids} is not \code{NULL}.}

\item{draw_ids}{An integer vector specifying the posterior draws to be used.
If \code{NULL} (the default), all draws are used.}

\item{sort}{Logical. Only relevant for time series models. 
Indicating whether to return predicted values in the original 
order (\code{FALSE}; default) or in the order of the 
time series (\code{TRUE}).}

\item{...}{Further arguments passed to \code{\link{prepare_predictions}}
that control several aspects of data validation and prediction.}
}
\value{
An S x N \code{array} of predictive error draws, where S is the
  number of posterior draws and N is the number of observations.
}
\description{
Compute posterior draws of predictive errors, that is, observed minus
predicted responses. Can be performed for the data used to fit the model
(posterior predictive checks) or for new data.
}
\examples{
\dontrun{
## fit a model
fit <- brm(rating ~ treat + period + carry + (1|subject), 
           data = inhaler, cores = 2)

## extract predictive errors
pe <- predictive_error(fit)
str(pe)
}

}
