context("b summaries")

vec <- c(1:5, NA, 5:1)

test_that("b functions return non NA value", {
  expect_equal(b_diff_max(vec), 1)
  expect_equal(b_diff_mean(vec), 0)
  expect_equal(b_diff_median(vec), 0)
  expect_equal(b_diff_min(vec), -1)
  expect_equal(b_diff_q25(vec), -1)
  expect_equal(b_diff_q75(vec), 1)
  expect_equal(b_diff_sd(vec), 1)
  expect_equal(b_diff_var(vec), 1)
  expect_equal(b_iqr(vec), (2 + 1/6))
  expect_equal(b_mad(vec), 1.4826)
  expect_equal(b_max(vec), 5)
  expect_equal(b_mean(vec), 3)
  expect_equal(b_median(vec), 3)
  expect_equal(b_min(vec), 1)
  expect_equal(b_q25(vec), (1.9 + (0.0001/0.006)))
  expect_equal(round(b_q75(vec),6), 4.083333)
  expect_equal(b_range(vec), c(1,5))
  expect_equal(b_range_diff(vec), 4)
  expect_equal(round(b_sd(vec), 6), 1.490712)
  expect_equal(round(b_var(vec), 6), 2.222222)
})
