% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/survival_tidiers.R
\name{survreg_tidiers}
\alias{augment.survreg}
\alias{glance.survreg}
\alias{survreg_tidiers}
\alias{tidy.survreg}
\title{Tidiers for a parametric regression survival model}
\usage{
\method{tidy}{survreg}(x, conf.level = 0.95, ...)

\method{augment}{survreg}(x, data = model.frame(x), newdata,
  type.predict = "response", type.residuals = "response", ...)

\method{glance}{survreg}(x, conf.level = 0.95, ...)
}
\arguments{
\item{x}{a "survreg" model}

\item{conf.level}{confidence level for CI}

\item{...}{extra arguments (not used)}

\item{data}{original data; if it is not provided, it is reconstructed
as best as possible with \code{\link{model.frame}}}

\item{newdata}{New data to use for prediction; optional}

\item{type.predict}{type of prediction, default "response"}

\item{type.residuals}{type of residuals to calculate, default "response"}
}
\value{
All tidying methods return a data.frame without rownames, whose
structure depends on the method chosen.

\code{tidy} returns a data.frame with one row for each term
  \item{term}{name of term}
  \item{estimate}{estimate of coefficient}
  \item{stderror}{standard error}
  \item{statistic}{Z statistic}
  \item{p.value}{p-value}
  \item{conf.low}{low end of confidence interval}
  \item{conf.high}{high end of confidence interval}

\code{augment} returns the original data.frame with the following
additional columns:
  \item{.fitted}{Fitted values of model}
  \item{.se.fit}{Standard errors of fitted values}
  \item{.resid}{Residuals}

\code{glance} returns a one-row data.frame with the columns:
  \item{iter}{number of iterations}
  \item{df}{degrees of freedom}
  \item{statistic}{chi-squared statistic}
  \item{p.value}{p-value from chi-squared test}
  \item{logLik}{log likelihood}
  \item{AIC}{Akaike information criterion}
  \item{BIC}{Bayesian information criterion}
  \item{df.residual}{residual degrees of freedom}
}
\description{
Tidies the coefficients of a parametric survival regression model,
from the "survreg" function, adds fitted values and residuals, or
summarizes the model statistics.
}
\details{
When the modeling was performed with \code{na.action = "na.omit"}
(as is the typical default), rows with NA in the initial data are omitted
entirely from the augmented data frame. When the modeling was performed
with \code{na.action = "na.exclude"}, one should provide the original data
as a second argument, at which point the augmented data will contain those
rows (typically with NAs in place of the new columns). If the original data
is not provided to \code{augment} and \code{na.action = "na.exclude"}, a
warning is raised and the incomplete rows are dropped.
}
\examples{
if (require("survival", quietly = TRUE)) {
    sr <- survreg(Surv(futime, fustat) ~ ecog.ps + rx, ovarian,
           dist="exponential")

    td <- tidy(sr)
    augment(sr, ovarian)
    augment(sr)
    glance(td)

    # coefficient plot
    library(ggplot2)
    ggplot(td, aes(estimate, term)) + geom_point() +
        geom_errorbarh(aes(xmin = conf.low, xmax = conf.high), height = 0) +
        geom_vline()
}
}
\seealso{
\link{na.action}
}

