% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/predictive_prior.R
\name{Prior_y}
\alias{Prior_y}
\alias{dprior_y}
\alias{pprior_y}
\alias{qprior_y}
\alias{rprior_y}
\alias{sprior_y}
\title{Prior predictive distribution of the count in the control group}
\usage{
dprior_y(y, a, b, T, ...)

pprior_y(q, a, b, T, ...)

qprior_y(p, a, b, T, ...)

rprior_y(n, a, b, T)

sprior_y(a, b, T, ...)
}
\arguments{
\item{y,q}{vector of non-negative \strong{integer} quantiles}

\item{a,b}{non-negative shape parameter and rate parameter of the Gamma prior distribution on the rate \eqn{\mu}}

\item{T}{sample size of the control group}

\item{...}{other arguments passed to \code{\link[stats]{NegBinomial}}
or \code{\link{summary_nbinom}} (for \code{sprior_y})}

\item{p}{vector of probabilities}

\item{n}{number of observations to be simulated}
}
\value{
\code{dprior_y} gives the density, \code{pprior_y} the distribution function,
\code{qprior_y} the quantile function, \code{rprior_y} samples from the distribution,
and \code{sprior_y} gives a summary of the distribution.
}
\description{
Density, distribution function, quantile function and random
generation for the prior predictive distribution of the count in the control group.










}
\details{
The prior predictive distribution of the count \eqn{y} is the Poisson-Gamma
 distribution
with shape parameter \eqn{a} and hyperrate parameter \eqn{b/T}, which is also
the negative binomial distribution with shape \eqn{a} and probability of success
\eqn{b/(b+T)}.
}
\note{
\code{Prior_y} is a generic name for the functions documented.
}
\examples{
barplot(dprior_y(0:10, 2, 2, 1))
sprior_y(2, 2, 1, output="pandoc")
}

