\name{brr-package}
\alias{brr-package}
\alias{brr}
\docType{package}
\title{
Bayesian inference on the ratio of two Poisson rates
}
\description{
Implementation of the Bayesian inference for the rate ratio of two independent Poisson samples, using the semi-conjugate family of prior distributions, and a default non-informative prior.

To learn more, start with the vignettes:
\code{browseVignettes(package="brr")}.

If you encounter a bug, or if you have a suggestion to improve the package, please file an issue on the github repo \url{https://github.com/stla/brr}.
}
\details{
\tabular{ll}{
Package: \tab brr\cr
Type: \tab Package\cr
Version: \tab 1.0.0\cr
Date: \tab 2015-09-07\cr
License: \tab GPL-2\cr
}
}

\author{
Stéphane Laurent
}

\references{
S. Laurent, C. Legrand (2012): 
A Bayesian framework for the ratio of two Poisson rates in the context of vaccine efficacy trials.
ESAIM, Probability \& Statistics 16 (2012), 375--398.

S. Laurent (2012):  
Some Poisson mixtures  distributions with a hyperscale parameter. 
Brazilian Journal of Probability and Statistics 26 (2012), 265--278.

S. Laurent (2012):
Intrinsic Bayesian inference on a Poisson rate and on the ratio of two Poisson rates. 
Journal of Statistical Planning and Inference 142 (2012), 2656--2671.
}
\keyword{ package }
\keyword{ models }
\keyword{ bayesian }
\keyword{ htest }
\keyword{ distribution }