% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bsTools2.R
\name{bs_modal}
\alias{bs_modal}
\title{Create a Bootstrap modal}
\usage{
bs_modal(
  id,
  header = button(attr = c(type = "button", class = "btn-close", `data-bs-dismiss` =
    "modal", `aria-label` = "Close")),
  title = h5("Note"),
  body,
  footer = button(attr = c(type = "button", class = "btn btn-secondary",
    `data-bs-dismiss` = "modal"), "Close"),
  modal_attr = c(class = "modal", tabindex = "-1"),
  dialog_attr = c(class = "modal-dialog"),
  content_attr = c(class = "modal-content"),
  header_attr = c(class = "modal-header"),
  title_attr = c(class = "modal-title"),
  body_attr = c(class = "modal-body"),
  footer_attr = c(class = "modal-footer")
)
}
\arguments{
\item{id}{A string, an id for the modal (to launch the modal, reference this id in the data-bs-target attribute of the HTML element
that will launch the modal. See example below).}

\item{header}{A string, likely HTML, that goes in the header div after the title.}

\item{title}{A string, likely HTML, displayed as the title of the modal.}

\item{body}{A string, likely HTML, displayed as the body of the modal.}

\item{footer}{A string, likely HTML, displayed at the bottom of the modal.}

\item{modal_attr}{A named list or named vector, names are attribute names and values are attribute values. Added to the the div wrapping the dialog.}

\item{dialog_attr}{A named list or named vector, names are attribute names and values are attribute values. Added to the the div wrapping the content wrapper.}

\item{content_attr}{A named list or named vector, names are attribute names and values are attribute values. Added to the the div wrapping the content (header, body, footer).}

\item{header_attr}{A named list or named vector, names are attribute names and values are attribute values. Added to the the div wrapping the header.}

\item{title_attr}{A named list or named vector, names are attribute names and values are attribute values. Added to the the div wrapping the title.}

\item{body_attr}{A named list or named vector, names are attribute names and values are attribute values. Added to the div wrapping the body.}

\item{footer_attr}{A named list or named vector, names are attribute names and values are attribute values. Added to the div wrapping the footer.}
}
\value{
A string of HTML.
}
\description{
Learn more at \url{https://getbootstrap.com/docs/5.1/components/modal/}.
}
\examples{
div(
button(
attr = c(
"type" = "button",
"class" = "btn btn-primary",
"data-bs-toggle" = "modal",
"data-bs-target" = "#modal1"
),
"Launch Modal"
),
bs_modal(
  id = "modal1",
  body = p("Here is the modal.")
)
)
}
