% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feed_quotes.R
\name{bs_get_quotes}
\alias{bs_get_quotes}
\title{Retrieve a list of quotes for a given post}
\usage{
bs_get_quotes(
  uri,
  cid,
  cursor = NULL,
  limit = NULL,
  user = get_bluesky_user(),
  pass = get_bluesky_pass(),
  auth = bs_auth(user, pass),
  clean = TRUE
)
}
\arguments{
\item{uri}{Character, length 1. URI for post to get.}

\item{cid}{Optional, character. Filters to quotes of specific version (by CID) of the post record}

\item{cursor}{Character, length 1. A cursor property from a prior response. Default: \code{NULL}.}

\item{limit}{Integer. Number of records to request. If over \code{100}, multiple requests are made.}

\item{user}{Character. User name to log in with. Defaults to \code{get_bluesky_user()}.}

\item{pass}{Character. App password to log in with. Defaults to \code{get_bluesky_pass()}.}

\item{auth}{Authentication information. Defaults to \code{bs_auth(user, pass)}.}

\item{clean}{Logical. Should output be cleaned into a \code{tibble}? Default: \code{TRUE}.}
}
\value{
a \link[tibble:tibble]{tibble::tibble} of quote posts
}
\description{
Retrieve a list of quotes for a given post
}
\section{Lexicon references}{

\href{https://github.com/bluesky-social/atproto/blob/main/lexicons/app/bsky/feed/getQuotes.json}{feed/getQuotes.json (2024-12-01)}
}

\section{Function introduced}{

\code{v0.2.0} (2024-12-01)
}

\examples{
\dontshow{if (has_bluesky_pass() && has_bluesky_user()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
bs_get_quotes('at://did:plc:5c2r73erhng4bszmxlfdtscf/app.bsky.feed.post/3lc5c5qv72r2w')
\dontshow{\}) # examplesIf}
}
\concept{feed}
