% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{gssm}
\alias{gssm}
\title{General univariate linear-Gaussian state space models}
\usage{
gssm(y, Z, H, T, R, a1, P1, xreg = NULL, beta, state_names, H_prior, Z_prior,
  T_prior, R_prior, obs_intercept, state_intercept)
}
\arguments{
\item{y}{Observations as time series (or vector) of length \eqn{n}.}

\item{Z}{System matrix Z of the observation equation. Either a vector of
length m or a m x n array, or an object which can be coerced to such.}

\item{H}{Vector of standard deviations. Either a scalar or a vector of length
n, or an object which can be coerced to such.}

\item{T}{System matrix T of the state equation. Either a m x m matrix or a
m x m x n array, or object which can be coerced to such.}

\item{R}{Lower triangular matrix R the state equation. Either a m x k matrix or a
m x k x n array, or object which can be coerced to such.}

\item{a1}{Prior mean for the initial state as a vector of length m.}

\item{P1}{Prior covariance matrix for the initial state as m x m matrix.}

\item{xreg}{Matrix containing covariates.}

\item{beta}{Regression coefficients. Used as an initial
value in MCMC. Defaults to vector of zeros.}

\item{state_names}{Names for the states.}

\item{H_prior, Z_prior, T_prior, R_prior}{Priors for the NA values in system matrices.}

\item{obs_intercept, state_intercept}{Intercept terms for observation and
state equations, given as a length n vector and m times n matrix respectively.}
}
\value{
Object of class \code{gssm}.
}
\description{
Construct an object of class \code{gssm} by defining the corresponding terms
of the observation and state equation:
}
\details{
\deqn{y_t = D_t + Z_t \alpha_t + H_t \epsilon_t, (\textrm{observation equation})}
\deqn{\alpha_{t+1} = C_t + T_t \alpha_t + R_t \eta_t, (\textrm{transition equation})}

where \eqn{\epsilon_t \sim N(0, 1)}, \eqn{\eta_t \sim N(0, I_k)} and
\eqn{\alpha_1 \sim N(a_1, P_1)} independently of each other.

The priors are defined for each NA value of the system matrices, in the same order as 
these values are naturally read in R. For more flexibility, see \code{\link{lgg_ssm}}.
}
