% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specify_bsvar.R
\name{specify_data_matrices}
\alias{specify_data_matrices}
\title{R6 Class Representing DataMatricesBSVAR}
\description{
The class DataMatricesBSVAR presents the data matrices of dependent variables, \eqn{Y}, and regressors, \eqn{X}, for the homoskedastic bsvar model.
}
\examples{
data(us_fiscal_lsuw)
YX = specify_data_matrices$new(data = us_fiscal_lsuw, p = 4)
dim(YX$Y); dim(YX$X)


## ------------------------------------------------
## Method `specify_data_matrices$get_data_matrices`
## ------------------------------------------------

data(us_fiscal_lsuw)
YX = specify_data_matrices$new(data = us_fiscal_lsuw, p = 4)
YX$get_data_matrices()

}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{Y}}{an \code{NxT} matrix of dependent variables, \eqn{Y}.}

\item{\code{X}}{an \code{KxT} matrix of regressors, \eqn{X}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-DataMatricesBSVAR-new}{\code{specify_data_matrices$new()}}
\item \href{#method-DataMatricesBSVAR-get_data_matrices}{\code{specify_data_matrices$get_data_matrices()}}
\item \href{#method-DataMatricesBSVAR-clone}{\code{specify_data_matrices$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DataMatricesBSVAR-new"></a>}}
\if{latex}{\out{\hypertarget{method-DataMatricesBSVAR-new}{}}}
\subsection{Method \code{new()}}{
Create new data matrices DataMatricesBSVAR.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{specify_data_matrices$new(data, p = 1L)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{a \code{(T+p)xN} matrix with time series data.}

\item{\code{p}}{a positive integer providing model's autoregressive lag order.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
New data matrices DataMatricesBSVAR.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DataMatricesBSVAR-get_data_matrices"></a>}}
\if{latex}{\out{\hypertarget{method-DataMatricesBSVAR-get_data_matrices}{}}}
\subsection{Method \code{get_data_matrices()}}{
Returns the data matrices DataMatricesBSVAR as a \code{list}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{specify_data_matrices$get_data_matrices()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{data(us_fiscal_lsuw)
YX = specify_data_matrices$new(data = us_fiscal_lsuw, p = 4)
YX$get_data_matrices()

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DataMatricesBSVAR-clone"></a>}}
\if{latex}{\out{\hypertarget{method-DataMatricesBSVAR-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{specify_data_matrices$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
