% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.PosteriorFEVD}
\alias{summary.PosteriorFEVD}
\title{Provides posterior summary of forecast error variance decompositions}
\usage{
\method{summary}{PosteriorFEVD}(object, ...)
}
\arguments{
\item{object}{an object of class PosteriorFEVD obtained using the
\code{compute_variance_decompositions()} function containing draws from the 
posterior distribution of the forecast error variance decompositions.}

\item{...}{additional arguments affecting the summary produced.}
}
\value{
A list reporting the posterior mean of the forecast error variance 
decompositions of each variable at all horizons.
}
\description{
Provides posterior means of the forecast error variance 
decompositions of each variable at all horizons.
}
\examples{
# upload data
data(us_fiscal_lsuw)

# specify the model and set seed
set.seed(123)
specification  = specify_bsvar$new(us_fiscal_lsuw)

# run the burn-in
burn_in        = estimate(specification, 10)

# estimate the model
posterior      = estimate(burn_in, 20, thin = 1)

# compute forecast error variance decompositions
fevd           = compute_variance_decompositions(posterior, horizon = 4)
fevd_summary   = summary(fevd)

# workflow with the pipe |>
############################################################
set.seed(123)
us_fiscal_lsuw |>
  specify_bsvar$new() |>
  estimate(S = 10) |> 
  estimate(S = 20, thin = 1) |> 
  compute_variance_decompositions(horizon = 4) |>
  summary() -> fevd_summary

}
\seealso{
\code{\link{compute_variance_decompositions}}
}
\author{
Tomasz Woźniak \email{wozniak.tom@pm.me}
}
