% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verify.R
\name{verify_volatility.PosteriorBSVARMIX}
\alias{verify_volatility.PosteriorBSVARMIX}
\title{Verifies heteroskedasticity of structural shocks equation by equation}
\usage{
\method{verify_volatility}{PosteriorBSVARMIX}(posterior)
}
\arguments{
\item{posterior}{the \code{posterior} element of the list from the estimation outcome}
}
\value{
An object of class \code{SDDRvolatility} that is a list of three components:

\code{logSDDR} an \code{N}-vector with values of the logarithm of the Bayes factors for 
the homoskedasticity hypothesis for each of the shocks

\code{log_SDDR_se} an \code{N}-vector with estimation standard errors of the logarithm of 
the Bayes factors reported in output element \code{logSDDR} that are computed based on 30 random 
sub-samples of the log-ordinates of the marginal posterior and prior distributions.

\code{components} a list of three components for the computation of the Bayes factor
\describe{
  \item{log_denominator}{an \code{N}-vector with values of the logarithm of the Bayes factor denominators}
  \item{log_numerator}{an \code{N}-vector with values of the logarithm of the Bayes factor numerators}
  \item{log_numerator_s}{an \code{NxS} matrix of the log-full conditional posterior density ordinates computed to estimate the numerator}
  \item{se_components}{an \code{Nx30} matrix containing the log-Bayes factors on the basis of which the standard errors are computed}
}
}
\description{
This function will be deprecated starting from version 4.0. 
It is replaced by \code{\link{verify_identification}} function.

Computes the logarithm of Bayes factor for the homoskedasticity hypothesis 
for each of the structural shocks via Savage-Dickey Density Ration (SDDR).
The hypothesis of homoskedasticity is represented by restriction:
\deqn{H_0: \sigma^2_{n.1} = ... = \sigma^2_{n.M} = 1}
The logarithm of Bayes factor for this hypothesis can be computed using the SDDR 
as the difference of logarithms of the marginal posterior distribution ordinate at the restriction 
less the marginal prior distribution ordinate at the same point:
\deqn{log p(\omega_n = 0 | data) - log p(\omega_n = 0)}
Therefore, a negative value of the difference is the evidence against 
homoskedasticity of the structural shock. The estimation of both elements of the difference requires 
numerical integration.
}
\examples{
# simple workflow
############################################################
# upload data
data(us_fiscal_lsuw)

# specify the model and set seed
specification  = specify_bsvar_mix$new(us_fiscal_lsuw, p = 1, M = 2)
set.seed(123)

# estimate the model
posterior      = estimate(specification, 10)

# verify heteroskedasticity
sddr           = verify_volatility(posterior)

# workflow with the pipe |>
############################################################
set.seed(123)
us_fiscal_lsuw |>
  specify_bsvar_mix$new(p = 1, M = 2) |>
  estimate(S = 10) |> 
  verify_volatility() -> sddr
  
}
\references{
Lütkepohl, H., and Woźniak, T., (2020) Bayesian Inference for Structural Vector Autoregressions Identified by Markov-Switching Heteroskedasticity. \emph{Journal of Economic Dynamics and Control} \bold{113}, 103862, \doi{10.1016/j.jedc.2020.103862}.

Lütkepohl, H., Shang, F., Uzeda, L., and Woźniak, T. (2024) Partial Identification of Heteroskedastic Structural VARs: Theory and Bayesian Inference. \emph{University of Melbourne Working Paper}, 1--57, \doi{10.48550/arXiv.2404.11057}.
}
\seealso{
\code{\link{specify_bsvar_mix}}, \code{\link{estimate}}
}
\author{
Tomasz Woźniak \email{wozniak.tom@pm.me}
}
