% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{tabulate.formula}
\alias{tabulate.formula}
\title{Parse a formula into a buildmer terms list}
\usage{
tabulate.formula(formula, group = NULL)
}
\arguments{
\item{formula}{A formula.}

\item{group}{A character vector of regular expressions. Terms matching the same regular expression are assigned the same block, and will be evaluated together in buildmer functions.}
}
\value{
A buildmer terms list, which is just a normal data frame.
}
\description{
Parse a formula into a buildmer terms list
}
\examples{
form <- diag(f1 ~ (vowel1+vowel2+vowel3+vowel4)*timepoint*following +
             ((vowel1+vowel2+vowel3+vowel4)*timepoint*following|participant) + (timepoint|word))
tabulate.formula(form)
tabulate.formula(form,group='vowel[1-4]')
}
\seealso{
buildmer-package
}
