% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adapt_hochwasserzentralen.R
\name{hochwasserzentralen_bundesland_geojson}
\alias{hochwasserzentralen_bundesland_geojson}
\title{Get Bundesland GeoJSON boundaries}
\usage{
hochwasserzentralen_bundesland_geojson(
  version,
  safe = TRUE,
  refresh = FALSE,
  flatten = FALSE,
  flatten_mode = "json"
)
}
\arguments{
\item{version}{GeoJSON version identifier (e.g., "20211130").}

\item{safe}{Logical; apply throttling and caching.}

\item{refresh}{Logical; refresh cached responses.}

\item{flatten}{Logical; drop nested list columns.}

\item{flatten_mode}{Flatten strategy for list columns. Use "unnest" to
expand list-columns into multiple rows.}
}
\value{
A tibble with GeoJSON metadata and feature list-columns.
}
\description{
Get Bundesland GeoJSON boundaries
}
\details{
Returns GeoJSON boundaries for Bundeslaender and connected regions from the
hochwasserzentralen.de portal. Official docs:
https://bundesapi.github.io/hochwasserzentralen-api/.
}
\examples{
\dontrun{
hochwasserzentralen_bundesland_geojson("20211130", flatten = TRUE)
}

}
