% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locate.R
\name{locate}
\alias{locate}
\title{Locate part of an object.}
\usage{
locate(x, name = NULL)
}
\arguments{
\item{x}{A model object.}

\item{name}{A name associated with model component of interest.
This defaults to NULL. Possible components include: \code{env},
\code{call}, \code{data}, \code{ctrl}, and \code{fitted}.}
}
\value{
Location of specific component in a model object.
}
\description{
Locate where a specific component of a object might exist within
the model object itself. This function is restricted in that only
items that can be axed can be found.
}
\examples{
lm_fit <- lm(mpg ~ ., data = mtcars)
locate(lm_fit, name = "env")
locate(lm_fit, name = "call")
}
