% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nnet.R
\name{axe-nnet}
\alias{axe-nnet}
\alias{axe_call.nnet}
\alias{axe_env.nnet}
\alias{axe_fitted.nnet}
\title{Axing a nnet.}
\usage{
\method{axe_call}{nnet}(x, verbose = FALSE, ...)

\method{axe_env}{nnet}(x, verbose = FALSE, ...)

\method{axe_fitted}{nnet}(x, verbose = FALSE, ...)
}
\arguments{
\item{x}{A model object.}

\item{verbose}{Print information each time an axe method is executed.
Notes how much memory is released and what functions are
disabled. Default is \code{FALSE}.}

\item{...}{Any additional arguments related to axing.}
}
\value{
Axed nnet object.
}
\description{
nnet objects are created from the \pkg{nnet} package, leveraged to
fit multilayer perceptron models.
}
\examples{
\dontshow{if (rlang::is_installed(c("parsnip", "nnet"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Load libraries
library(parsnip)
library(nnet)

# Create and fit model
nnet_fit <- mlp("classification", hidden_units = 2) \%>\%
  set_engine("nnet") \%>\%
  fit(Species ~ ., data = iris)

out <- butcher(nnet_fit, verbose = TRUE)

# Another nnet object
targets <- class.ind(c(rep("setosa", 50),
                       rep("versicolor", 50),
                       rep("virginica", 50)))

fit <- nnet(iris[,1:4],
            targets,
            size = 2,
            rang = 0.1,
            decay = 5e-4,
            maxit = 20)

out <- butcher(fit, verbose = TRUE)
\dontshow{\}) # examplesIf}
}
