% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mass.R
\name{axe-mass}
\alias{axe-mass}
\alias{axe-lda}
\alias{axe-qda}
\alias{axe_env.lda}
\alias{axe_env.qda}
\title{Axing a MASS discriminant analysis object.}
\usage{
\method{axe_env}{lda}(x, verbose = FALSE, ...)

\method{axe_env}{qda}(x, verbose = FALSE, ...)
}
\arguments{
\item{x}{A model object.}

\item{verbose}{Print information each time an axe method is executed.
Notes how much memory is released and what functions are
disabled. Default is \code{FALSE}.}

\item{...}{Any additional arguments related to axing.}
}
\value{
Axed lda or qda object.
}
\description{
lda and qda objects are created from the \pkg{MASS} package, leveraged to
carry out linear discriminant analysis and quadratic discriminant
analysis, respectively.
}
\examples{
\dontshow{if (rlang::is_installed("MASS")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(MASS)

fit_da <- function(fit_fn) {
  boop <- runif(1e6)
  fit_fn(y ~ x, data.frame(y = rep(letters[1:4], 10000), x = rnorm(40000)))
}

lda_fit <- fit_da(lda)
qda_fit <- fit_da(qda)

lda_fit_b <- butcher(lda_fit)
qda_fit_b <- butcher(qda_fit)

weigh(lda_fit)
weigh(lda_fit_b)

weigh(qda_fit)
weigh(qda_fit_b)
\dontshow{\}) # examplesIf}
}
