% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/criteria.R
\name{logLik.varlse}
\alias{logLik.varlse}
\alias{logLik.vharlse}
\alias{logLik.bvarmn}
\alias{logLik.bvarflat}
\alias{logLik.bvharmn}
\title{Extract Log-Likelihood of Multivariate Time Series Model}
\usage{
\method{logLik}{varlse}(object, ...)

\method{logLik}{vharlse}(object, ...)

\method{logLik}{bvarmn}(object, ...)

\method{logLik}{bvarflat}(object, ...)

\method{logLik}{bvharmn}(object, ...)
}
\arguments{
\item{object}{Model fit}

\item{...}{not used}
}
\value{
A \code{logLik} object.
}
\description{
Compute log-likelihood function value of VAR(p), VHAR, BVAR(p), and BVHAR
}
\details{
Consider the response matrix \eqn{Y_0}.
Let \eqn{n} be the total number of sample,
let \eqn{m} be the dimension of the time series,
let \eqn{p} be the order of the model,
and let \eqn{s = n - p}.
Likelihood of VAR(p) has

\deqn{Y_0 \mid B, \Sigma_e \sim MN(X_0 B, I_s, \Sigma_e)}

where \eqn{X_0} is the design matrix,
and MN is \href{https://en.wikipedia.org/wiki/Matrix_normal_distribution}{matrix normal distribution}.

Then log-likelihood of vector autoregressive model family is specified by

\deqn{\log p(Y_0 \mid B, \Sigma_e) = - \frac{sm}{2} \log 2\pi - \frac{s}{2} \log \det \Sigma_e - \frac{1}{2} tr( (Y_0 - X_0 B) \Sigma_e^{-1} (Y_0 - X_0 B)^T )}

In addition, recall that the OLS estimator for the matrix coefficient matrix is the same as MLE under the Gaussian assumption.
MLE for \eqn{\Sigma_e} has different denominator, \eqn{s}.

\deqn{\hat{B} = \hat{B}^{LS} = \hat{B}^{ML} = (X_0^T X_0)^{-1} X_0^T Y_0}
\deqn{\hat\Sigma_e = \frac{1}{s - k} (Y_0 - X_0 \hat{B})^T (Y_0 - X_0 \hat{B})}
\deqn{\tilde\Sigma_e = \frac{1}{s} (Y_0 - X_0 \hat{B})^T (Y_0 - X_0 \hat{B}) = \frac{s - k}{s} \hat\Sigma_e}

In case of VHAR, just consider the linear relationship.

While frequentist models use OLS and MLE for coefficient and covariance matrices, Bayesian models implement posterior means.
}
\references{
Lütkepohl, H. (2007). \emph{New Introduction to Multiple Time Series Analysis}. Springer Publishing.

Corsi, F. (2008). \emph{A Simple Approximate Long-Memory Model of Realized Volatility}. Journal of Financial Econometrics, 7(2), 174–196.

Bańbura, M., Giannone, D., & Reichlin, L. (2010). \emph{Large Bayesian vector auto regressions}. Journal of Applied Econometrics, 25(1).

Litterman, R. B. (1986). \emph{Forecasting with Bayesian Vector Autoregressions: Five Years of Experience}. Journal of Business & Economic Statistics, 4(1), 25.

Ghosh, S., Khare, K., & Michailidis, G. (2018). \emph{High-Dimensional Posterior Consistency in Bayesian Vector Autoregressive Models}. Journal of the American Statistical Association, 114(526).
}
\seealso{
\itemize{
\item \code{\link[=var_lm]{var_lm()}}
\item \link{var_design_formulation}
}

\code{\link[=vhar_lm]{vhar_lm()}}

\code{\link[=bvar_minnesota]{bvar_minnesota()}}

\code{\link[=bvar_flat]{bvar_flat()}}

\code{\link[=bvhar_minnesota]{bvhar_minnesota()}}
}
