% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelling.R
\name{printSubset}
\alias{printSubset}
\title{Convenience method for printing model selection information}
\usage{
printSubset(x, ...)
}
\arguments{
\item{x}{The model from the 'bestModel' function or a cnorm object}

\item{...}{additional parameters}
}
\value{
A table with information criteria
}
\description{
After conducting the model fitting procedure on the data set, the best fitting
model has to be chosen. The print function shows the R2 and other information
on the different best fitting models with increasing number of predictors.
}
\examples{
# Generate cnorm object from example data
result <- cnorm(raw = elfe$raw, group = elfe$group)
printSubset(result)
}
\seealso{
Other model: 
\code{\link{bestModel}()},
\code{\link{checkConsistency}()},
\code{\link{cnorm.cv}()},
\code{\link{derive}()},
\code{\link{modelSummary}()},
\code{\link{print.cnorm}()},
\code{\link{rangeCheck}()},
\code{\link{regressionFunction}()},
\code{\link{summary.cnorm}()}
}
\concept{model}
