% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zz_arguments.R
\name{csem_arguments}
\alias{csem_arguments}
\alias{cSEMArguments}
\title{cSEMArguments}
\arguments{
\item{.alpha}{An integer or a numeric vector of significance levels.
Defaults to \code{0.05}.}

\item{.absolute}{Logical. Should the absolute HTMT values be returned?
Defaults to \code{TRUE} .}

\item{.approach_gcca}{Character string. The Kettenring approach to use for GCCA. One of
"\emph{SUMCORR}", "\emph{MAXVAR}", "\emph{SSQCORR}", "\emph{MINVAR}" or "\emph{GENVAR}". Defaults to
"\emph{SUMCORR}".}

\item{.approach_2ndorder}{Character string. Approach used for models containing
second-order constructs. One of: "\emph{2stage}", or "\emph{mixed}". Defaults to "\emph{2stage}".}

\item{.approach_alpha_adjust}{Character string. Approach used to adjust the
significance level to accommodate multiple testing.
One of "\emph{none}" or "\emph{bonferroni}". Defaults to "\emph{none}".}

\item{.approach_cor_robust}{Character string. Approach used to obtain a robust
indicator correlation matrix. One of: "\emph{none}" in which case the standard
Bravais-Person correlation is used,
"\emph{spearman}" for the Spearman rank correlation, or
"\emph{mcd}" via \code{\link[MASS:cov.rob]{MASS::cov.rob()}} for a robust correlation matrix.
Defaults to "\emph{none}". Note that many postestimation procedures (such as
\code{\link[=testOMF]{testOMF()}} or \code{\link[=fit]{fit()}} implicitly assume a continuous
indicator correlation matrix (e.g. Bravais-Pearson correlation matrix).
Only use if you know what you are doing.}

\item{.approach_mgd}{Character string or a vector of character strings.
Approach used for the multi-group comparison. One of: "\emph{all}", "\emph{Klesel}", "\emph{Chin}",
"\emph{Sarstedt}", "\emph{Keil}, "\emph{Nitzl}", "\emph{Henseler}", "\emph{CI_para}", or "\emph{CI_overlap}".
Default to "\emph{all}" in which case all approaches are computed (if possible).}

\item{.approach_nl}{Character string. Approach used to estimate nonlinear
structural relationships. One of: "\emph{sequential}" or "\emph{replace}".
Defaults to "\emph{sequential}".}

\item{.approach_p_adjust}{Character string or a vector of character strings.
Approach used to adjust the p-value for multiple testing.
See the \code{methods} argument of \code{\link[stats:p.adjust]{stats::p.adjust()}} for a list of choices and
their description. Defaults to "\emph{none}".}

\item{.approach_paths}{Character string. Approach used to estimate the
structural coefficients. One of: "\emph{OLS}" or "\emph{2SLS}". If "\emph{2SLS}", instruments
need to be supplied to \code{.instruments}. Defaults to "\emph{OLS}".}

\item{.approach_weights}{Character string. Approach used to
obtain composite weights. One of: "\emph{PLS-PM}", "\emph{SUMCORR}", "\emph{MAXVAR}",
"\emph{SSQCORR}", "\emph{MINVAR}", "\emph{GENVAR}", "\emph{GSCA}", "\emph{PCA}", "\emph{unit}", "\emph{bartlett}",
or "\emph{regression}". Defaults to "\emph{PLS-PM}".}

\item{.args_used}{A list of function argument names whose value was modified
by the user.}

\item{.attrbutes}{Character string. Variables used as attributes in IPMA.}

\item{.benchmark}{Character string. The procedure to obtain benchmark predictions.
One of "\emph{lm}", "\emph{unit}", "\emph{PLS-PM}", "\emph{GSCA}", "\emph{PCA}", or "\emph{MAXVAR}".
Default to "\emph{lm}".}

\item{.bias_corrected}{Logical. Should the standard and the tStat
confidence interval be bias-corrected using the bootstrapped bias estimate?
If \code{TRUE} the confidence interval for some estimated parameter \code{theta}
is centered at \verb{2*theta - theta*_hat},
where \verb{theta*_hat} is the average over all \code{.R} bootstrap estimates of \code{theta}.
Defaults to \code{TRUE}}

\item{.by_equation}{Should the criteria be computed for each structural model
equation separately? Defaults to \code{TRUE}.}

\item{.C}{A (J x J) composite variance-covariance matrix.}

\item{.check_errors}{Logical. Should the model to parse be checked for correctness
in a sense that all necessary components to estimate the model are given?
Defaults to \code{TRUE}.}

\item{.choices}{Logical. Should candidate values for the arguments be returned?
Defaults to \code{FALSE}.}

\item{.ci}{A vector of character strings naming the confidence interval to compute.
For possible choices see \code{\link[=infer]{infer()}}.}

\item{.ci_colnames}{Internal argument used by several print helper functions.}

\item{.closed_form_ci}{Logical. Should a closed-form confidence interval be computed?
Defaults to \code{FALSE}.}

\item{.conv_criterion}{Character string. The criterion to use for the convergence check.
One of: "\emph{diff_absolute}", "\emph{diff_squared}", or "\emph{diff_relative}". Defaults
to "\emph{diff_absolute}".}

\item{.csem_model}{A (possibly incomplete) \link{cSEMModel}-list.}

\item{.csem_resample}{A list resulting from a call to \code{\link[=resamplecSEMResults]{resamplecSEMResults()}}.}

\item{.cv_folds}{Integer. The number of cross-validation folds to use. Setting
\code{.cv_folds} to \code{N} (the number of observations) produces
leave-one-out cross-validation samples. Defaults to \code{10}.}

\item{.data}{A \code{data.frame} or a \code{matrix} of standardized or unstandardized
data (indicators/items/manifest variables). Possible column types or classes
of the data provided are: "\code{logical}", "\code{numeric}" ("\code{double}" or "\code{integer}"),
"\code{factor}" ("\code{ordered}" and/or "\code{unordered}"), "\code{character}" (converted to factor),
or a mix of several types.}

\item{.dependent}{Character string. The name of the dependent variable.}

\item{.disattenuate}{Logical. Should composite/proxy correlations
be disattenuated to yield consistent loadings and path estimates if at least
one of the construct is modeled as a common factor? Defaults to \code{TRUE}.}

\item{.dist}{Character string. The distribution to use for the critical value.
One of \emph{"t"} for Student's t-distribution or \emph{"z"} for the standard normal distribution.
Defaults to \emph{"z"}.}

\item{.distance}{Character string. A distance measure. One of: "\emph{geodesic}"
or "\emph{squared_euclidian}". Defaults to "\emph{geodesic}".}

\item{.df}{Character string. The method for obtaining the degrees of freedom.
Choices are "\emph{type1}" and "\emph{type2}". Defaults to "\emph{type1}" .}

\item{.dominant_indicators}{A character vector of \code{"construct_name" = "indicator_name"} pairs,
where \code{"indicator_name"} is a character string giving the name of the dominant indicator
and \code{"construct_name"} a character string of the corresponding construct name.
Dominant indicators may be specified for a subset of the constructs.
Default to \code{NULL}.}

\item{.E}{A (J x J) matrix of inner weights.}

\item{.effect}{Internal argument used by helper printEffects().}

\item{.estimate_structural}{Logical. Should the structural coefficients
be estimated? Defaults to \code{TRUE}.}

\item{.eval_plan}{Character string. The evaluation plan to use. One of
"\emph{sequential}" or "\emph{multiprocess}". In the latter case
all available cores will be used. Defaults to "\emph{sequential}".}

\item{.filename}{Character string. The file name. Defaults to "results.xlsx".}

\item{.first_resample}{A list containing the \code{.R} resamples based on the original
data obtained by resamplecSEMResults().}

\item{.fit_measures}{Logical. (EXPERIMENTAL) Should additional fit measures
be included? Defaults to \code{FALSE}.}

\item{.force}{Logical. Should .object be resampled even if it contains resamples
already?. Defaults to \code{FALSE}.}

\item{.full_output}{Logical. Should the full output of summarize be printed.
Defaults to \code{TRUE}.}

\item{.H}{The (N x J) matrix of construct scores.}

\item{.handle_inadmissibles}{Character string. How should inadmissible results
be treated? One of "\emph{drop}", "\emph{ignore}", or "\emph{replace}". If "\emph{drop}", all
replications/resamples yielding an inadmissible result will be dropped
(i.e. the number of results returned will potentially be less than \code{.R}).
For "\emph{ignore}" all results are returned even if all or some of the replications
yielded inadmissible results (i.e. number of results returned is equal to \code{.R}).
For "\emph{replace}" resampling continues until there are exactly \code{.R} admissible solutions.
Depending on the frequency of inadmissible solutions this may significantly increase
computing time. Defaults to "\emph{drop}".}

\item{.id}{Character string or integer. A character string giving the name or
an integer of the position of the column of \code{.data} whose levels are used
to split \code{.data} into groups. Defaults to \code{NULL}.}

\item{.inference}{Logical. Should critical values be computed? Defaults to \code{FALSE}.}

\item{.independent}{Character string. The name of the independent variable.}

\item{.instruments}{A named list of vectors of instruments. The names
of the list elements are the names of the dependent (LHS) constructs of the structural
equation whose explanatory variables are endogenous. The vectors
contain the names of the instruments corresponding to each equation. Note
that exogenous variables of a given equation \strong{must} be supplied as
instruments for themselves. Defaults to \code{NULL}.}

\item{.iter_max}{Integer. The maximum number of iterations allowed.
If \code{iter_max = 1} and \code{.approach_weights = "PLS-PM"} one-step weights are returned.
If the algorithm exceeds the specified number, weights of iteration step
\code{.iter_max - 1}  will be returned with a warning. Defaults to \code{100}.}

\item{.level}{Character. Used in \code{plot.cSEMIPMA} to indicate whether IPMA should be done
for constructs or indicators.}

\item{.matrix1}{A \code{matrix} to compare.}

\item{.matrix2}{A \code{matrix} to compare.}

\item{.matrices}{A list of at least two matrices.}

\item{.model}{A model in \link[lavaan:model.syntax]{lavaan model syntax}
or a \link{cSEMModel} list.}

\item{.moderator}{Character string. The name of the moderator variable.}

\item{.modes}{A vector giving the mode for each construct in the form \code{"name" = "mode"}.
Only used internally.}

\item{.ms_criterion}{Character string. Either a single character string or a vector
of character strings naming the model selection criterion to compute.
Defaults to \code{"all"}.}

\item{.n}{Integer. The number of observations of the original data.}

\item{.n_steps}{Integer. A value giving the number of steps (the spotlights, i.e.,
values of .moderator in surface analysis or floodlight analysis)
between the minimum and maximum value of the moderator. Defaults to \code{100}.}

\item{.normality}{Logical. Should joint normality of
\eqn{[\eta_{1:p}; \zeta; \epsilon]}{[\eta_(1:p); \zeta; \epsilon]}
be assumed in the nonlinear model? See \insertCite{Dijkstra2014}{cSEM} for details.
Defaults to \code{FALSE}. Ignored if the model is not nonlinear.}

\item{.nr_comparisons}{Integer. The number of comparisons. Defaults to \code{NULL}.}

\item{.null_model}{Logical. Should the degrees of freedom for the null model
be computed? Defaults to \code{FALSE}.}

\item{.object}{An R object of class \link{cSEMResults} resulting from a call to \code{\link[=csem]{csem()}}.}

\item{.only_common_factors}{Logical. Should only concepts modeled as common
factors be included when calculating one of the following quality critera:
AVE, the Fornell-Larcker criterion, HTMT, and all reliability estimates.
Defaults to \code{TRUE}.}

\item{.only_structural}{Should the the log-likelihood be based on the
structural model? Ignored if \code{.by_equation == TRUE}. Defaults to \code{TRUE}.}

\item{.original_arguments}{The list of arguments used within \code{\link[=csem]{csem()}}.}

\item{.output_type}{Character string. The type of output to return. One of
"\emph{complete}" or "\emph{structured}". See the Value section for details. Defaults to
"\emph{complete}".}

\item{.P}{A (J x J) construct variance-covariance matrix (possibly disattenuated).}

\item{.parameters_to_compare}{A model in \link[lavaan:model.syntax]{lavaan model syntax} indicating which
parameters (i.e, path (\code{~}), loadings (\verb{=~}), weights (\verb{<~}), or correlations (\verb{~~})) should be
compared across groups. Defaults to \code{NULL} in which case all weights, loadings and
path coefficients of the originally specified model are compared.}

\item{.path}{Character string. Path of the directory to save the file to. Defaults
to the current working directory.}

\item{.path_coefficients}{List. A list that contains the resampled and the original
path coefficient estimates. Typically a part of a \code{cSEMResults_resampled} object.
Defaults to \code{NULL}.}

\item{.PLS_approach_cf}{Character string. Approach used to obtain the correction
factors for PLSc. One of: "\emph{dist_squared_euclid}", "\emph{dist_euclid_weighted}",
"\emph{fisher_transformed}", "\emph{mean_arithmetic}", "\emph{mean_geometric}", "\emph{mean_harmonic}",
"\emph{geo_of_harmonic}". Defaults to "\emph{dist_squared_euclid}".
Ignored if \code{.disattenuate = FALSE} or if \code{.approach_weights} is not PLS-PM.}

\item{.plot_package}{Character string. Indicates which packages should be used for plotting.}

\item{.plot_type}{Character string. Indicates the type of plot that is produced.}

\item{.PLS_ignore_structural_model}{Logical. Should the structural model be ignored
when calculating the inner weights of the PLS-PM algorithm? Defaults to \code{FALSE}.
Ignored if \code{.approach_weights} is not PLS-PM.}

\item{.PLS_modes}{Either a named list specifying the mode that should be used for
each construct in the form \code{"construct_name" = mode}, a single character
string giving the mode that should be used for all constructs, or \code{NULL}.
Possible choices for \code{mode} are: "\emph{modeA}", "\emph{modeB}", "\emph{modeBNNLS}",
"\emph{unit}", "\emph{PCA}", a single integer or
a vector of fixed weights of the same length as there are indicators for the
construct given by \code{"construct_name"}. If only a single number is provided this is identical to
using unit weights, as weights are rescaled such that the related composite
has unit variance.  Defaults to \code{NULL}.
If \code{NULL} the appropriate mode according to the type
of construct used is chosen. Ignored if \code{.approach_weight} is not PLS-PM.}

\item{.PLS_weight_scheme_inner}{Character string. The inner weighting scheme
used by PLS-PM. One of: "\emph{centroid}", "\emph{factorial}", or "\emph{path}".
Defaults to "\emph{path}". Ignored if \code{.approach_weight} is not PLS-PM.}

\item{.probs}{A vector of probabilities.}

\item{.postestimation_object}{An object resulting from a call to one of cSEM's
postestimation functions (e.g. \code{\link[=summarize]{summarize()}}).}

\item{.quality_criterion}{Character string. A single character string or a
vector of character strings naming the quality criterion to compute. See
the Details section for a list of possible candidates.
Defaults to "\emph{all}" in which case all possible quality criteria are computed.}

\item{.quantity}{Character string. Which statistic should be returned?
One of "\emph{all}", "\emph{mean}", "\emph{sd}", "\emph{bias}", "\emph{CI_standard_z}", "\emph{CI_standard_t}",
"\emph{CI_percentile}", "\emph{CI_basic}", "\emph{CI_bc}", "\emph{CI_bca}", "\emph{CI_t_interval}"
Defaults to "\emph{all}" in which case all quantities that do not require
additional resampling are returned, i.e., all quantities but "\emph{CI_bca}", "\emph{CI_t_interval}".}

\item{.Q}{A vector of composite-construct correlations with element names equal to
the names of the J construct names used in the measurement model. Note
Q^2 is also called the reliability coefficient.}

\item{.reliabilities}{A character vector of \code{"name" = value} pairs,
where \code{value} is a number between 0 and 1 and \code{"name"} a character string
of the corresponding construct name, or \code{NULL}. Reliabilities
may be given for a subset of the constructs. Defaults to \code{NULL} in which case
reliabilities are estimated by \code{csem()}. Currently, only supported for
\code{.approach_weights = "PLS-PM"}.}

\item{.resample_method}{Character string. The resampling method to use. One of:
"\emph{none}", "\emph{bootstrap}" or "\emph{jackknife}". Defaults to "\emph{none}".}

\item{.resample_method2}{Character string. The resampling method to use when resampling
from a resample. One of: "\emph{none}", "\emph{bootstrap}" or "\emph{jackknife}". For
"\emph{bootstrap}" the number of draws is provided via \code{.R2}. Currently,
resampling from each resample is only required for the studentized confidence
intervall ("\emph{CI_t_interval}") computed by the \code{\link[=infer]{infer()}} function. Defaults to "\emph{none}".}

\item{`.resample_object`}{An R object of class \code{cSEMResults_resampled}
obtained from \code{\link[=resamplecSEMResults]{resamplecSEMResults()}} or by setting \code{.resample_method = "bootstrap"}
or \code{"jackknife"} when calling \code{\link[=csem]{csem()}}.}

\item{.resample_sarstedt}{A matrix containing the parameter estimates that
could potentially be compared and an id column indicating the group adherence
of each row.}

\item{.r}{Integer. The number of repetitions to use. Defaults to \code{10}.}

\item{.R}{Integer. The number of bootstrap replications. Defaults to \code{499}.}

\item{.R2}{Integer. The number of bootstrap replications to use when
resampling from a resample. Defaults to \code{199}.}

\item{.R_bootstrap}{Integer. The number of bootstrap runs. Ignored if \code{.object}
contains resamples. Defaults to \code{499}}

\item{.R_permutation}{Integer. The number of permutations. Defaults to \code{499}}

\item{.S}{The (K x K) empirical indicator correlation matrix.}

\item{.saturated}{Logical. Should a saturated structural model be used?
Defaults to \code{FALSE}.}

\item{.second_resample}{A list containing \code{.R2} resamples for each of the \code{.R}
resamples of the first run.}

\item{.seed}{Integer or \code{NULL}. The random seed to use. Defaults to \code{NULL} in which
case an arbitrary seed is chosen. Note that the scope of the seed is limited
to the body of the function it is used in. Hence, the global seed will
not be altered!}

\item{.sign_change_option}{Character string. Which sign change option should
be used to handle flipping signs when resampling? One of "\emph{none}","\emph{individual}",
"\emph{individual_reestimate}", "\emph{construct_reestimate}". Defaults to "\emph{none}".}

\item{.stage}{Character string. The stage the model is needed for.
One of "\emph{first}" or "\emph{second}". Defaults to "\emph{first}".}

\item{.standardized}{Logical. Should standardized scores be returned? Defaults
to \code{TRUE}.}

\item{.starting_values}{A named list of vectors where the
list names are the construct names whose indicator weights the user
wishes to set. The vectors must be named vectors of \code{"indicator_name" = value}
pairs, where \code{value} is the (scaled or unscaled) starting weight. Defaults to \code{NULL}.}

\item{.steps_mod}{A numeric vector. Steps used for the moderator variable in calculating
the simple effects of an independent variable on the dependent variable.
Defaults to \code{NULL}.}

\item{.terms}{A vector of construct names to be classified.}

\item{.test_data}{A matrix of test data with the same column names as the
training data.}

\item{.tolerance}{Double. The tolerance criterion for convergence.
Defaults to \code{1e-05}.}

\item{.type_gfi}{Character string. Which fitting function should the GFI be based
on? One of \emph{"ML"} for the maximum likelihood fitting function, \emph{"GLS"} for
the generalized least squares fitting function or \emph{"ULS"} for the
unweighted least squares fitting function (same as the squared Euclidian distance).
Defaults to \emph{"ML"}.}

\item{.type_ci}{Character string. Which confidence interval should be calculated?
For possible choices, see the \code{.quantity} argument of the \code{\link[=infer]{infer()}} function.
Only used if \code{.approch_mgd} is one of "\emph{CI_para}" or "\emph{CI_overlap}". Ignored otherwise.
Defaults to "\emph{CI_percentile}".}

\item{.type_htmt}{Character string indicating the type of HTMT that should be
calculated, i.e., the original HTMT ("\emph{htmt}") or the HTMT2 ("\emph{htmt2}").
Defaults to "\emph{htmt}"}

\item{.type_vcv}{Character string. Which model-implied correlation
matrix should be calculated?
One of "\emph{indicator}" or "\emph{construct}". Defaults to "\emph{indicator}".}

\item{.verbose}{Logical. Should information (e.g., progress bar) be printed
to the console? Defaults to \code{TRUE}.}

\item{.user_funs}{A function or a (named) list of functions to apply to every
resample. The functions must take \code{.object} as its first argument (e.g.,
\verb{myFun <- function(.object, ...) \{body-of-the-function\}}).
Function output should preferably be a (named)
vector but matrices are also accepted. However, the output will be
vectorized (columnwise) in this case. See the examples section for details.}

\item{.value_independent}{Integer. Only required for floodlight analysis;
The value of the independent variable in case that it appears as a
higher-order term.}

\item{.values_moderator}{A numeric vector. The values of the moderator in a
the simple effects analysis. Typically these are difference from the mean (=0)
measured in standard deviations. Defaults to \code{c(-2, -1, 0, 1, 2)}.}

\item{.vcv_asymptotic}{Logical. Should the asymptotic variance-covariance matrix be used, i.e.,
VCV(b0) - VCV(b1)= VCV(b1-b0), or should VCV(b1-b0) be computed directly?
Defaults to \code{FALSE}.}

\item{.vector1}{A vector of numeric values.}

\item{.vector2}{A vector of numeric values.}

\item{.W}{A (J x K) matrix of weights.}

\item{.what}{Internal argument used by several print helper functions.}

\item{.W_new}{A (J x K) matrix of weights.}

\item{.W_old}{A (J x K) matrix of weights.}

\item{.weighted}{Logical. Should estimation be based on a score that uses
the weights of the weight approach used to obtain \code{.object}?. Defaults to \code{FALSE}.}

\item{.X}{A matrix of processed data (scaled, cleaned and ordered).}

\item{.X_cleaned}{A data.frame of processed data (cleaned and ordered). Note: \code{X_cleaned}
may not be scaled!}
}
\description{
An alphabetical list of all arguments used by functions of the \code{cSEM} package
including their description and defaults.
Mainly used for internal purposes (parameter inheritance). To list all arguments
and their defaults, use \code{\link[=args_default]{args_default()}}. To list all arguments and
their possible choices, use \code{args_default(.choices = TRUE)}.
}
\keyword{internal}
