% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/french.R
\name{french_date}
\alias{french_date}
\alias{afrench_date}
\alias{as_french}
\alias{as_afrench}
\title{French Revolutionary calendar dates}
\usage{
french_date(year = integer(), month = integer(), day = integer())

afrench_date(year = integer(), month = integer(), day = integer())

as_french(date)

as_afrench(date)
}
\arguments{
\item{year}{year}

\item{month}{month}

\item{day}{day}

\item{date}{A vector of dates on some calendar}
}
\value{
A vector of dates on the French Revolutionary calendar
}
\description{
There are two versions of the French Revolutionary Calendar. The original
version, used from 1793, was kept in sync with the solar year by setting the first day of
Vendemiaire to the autumnal equinox. The second version, proposed in 1795, was a simpler
arithmetic calendar, but was never used. We distinguish the two by using "afrench"
(for Arithmetic French) for the second form.
}
\examples{
french_date(1, 1, 1:15) |>
  as_gregorian()
french_date(1, 1, 1:15) |>
  day_of_week()
}
