# TODO: Add comment
# 
# Author: samarov
###############################################################################

load("inst/unitTests/data/RUnitData.rda")
load("inst/unitTests/data/RUnitCalibTestData.rda")
ELISA <- read.table("data/ELISA.txt", header = TRUE)
HPLC <- read.table("data/HPLC.txt", header = TRUE)
library(RUnit)

test.calibObject <- function(){
	
	## 1-07-09: A quick note on some the unit tests here. The inver.up and inver.low calculations
	## have an error in the previous calib code. There needs the be the constant 1/n multiplying
	## the unscaled covariance matrix which was previously missing. This has been corrected in 
	## this version. DVS
	
	mod.fpl <- calib.fit(ELISA[,1], ELISA[,2], type = "fpl", m = 2)
	mod.fpl.pom <- calib.fit(ELISA[,1], ELISA[,2], type = "fpl.pom", m = 2)
	mod.log.fpl <- calib.fit(ELISA[,1], ELISA[,2], type = "log.fpl", m = 2)
	mod.log.fpl.pom <- calib.fit(ELISA[,1], ELISA[,2], type = "log.fpl.pom", m = 2)
	mod.thpl <- calib.fit(ELISA[,1], ELISA[,2], type = "thpl", m = 2)
	mod.thpl.pom <- calib.fit(ELISA[,1], ELISA[,2], type = "thpl.pom", m = 2)
	mod.tpl <- calib.fit(ELISA[,1], ELISA[,2], type = "tpl", m = 2)
	mod.tpl.pom <- calib.fit(ELISA[,1], ELISA[,2], type = "tpl.pom", m = 2)
	mod.log.tpl <- calib.fit(ELISA[,1], ELISA[,2], type = "log.tpl", m = 2)
	mod.log.tpl.pom <- calib.fit(ELISA[,1], ELISA[,2], type = "log.tpl.pom", m = 2)
	mod.lin <- calib.fit(HPLC[,1], HPLC[,2], type = "lin.pom", m = 2)
	mod.quad <- calib.fit(HPLC[,1], HPLC[,2], type = "quad.pom", m = 2)
	
	calib.mod.fpl <- calib(mod.fpl, ELISA[,2], m = 2)
	calib.mod.fpl.pom <- calib(mod.fpl.pom, ELISA[,2], m = 2)
	calib.mod.log.fpl <- calib(mod.fpl.pom, ELISA[,2], m = 2)
	calib.mod.log.fpl.pom <- calib(mod.fpl.pom, ELISA[,2], m = 2)
	calib.mod.thpl <- calib(mod.thpl, ELISA[,2], m = 2)
	calib.mod.thpl.pom <- calib(mod.thpl.pom, ELISA[,2], m = 2)
	calib.mod.tpl <- calib(mod.tpl, ELISA[,2], m = 2)
	calib.mod.tpl.pom <- calib(mod.tpl.pom, ELISA[,2], m = 2)
	calib.mod.log.tpl <- calib(mod.log.tpl, ELISA[,2], m = 2)
	calib.mod.log.tpl.pom <- calib(mod.log.tpl.pom, ELISA[,2], m = 2)
	calib.mod.lin <- calib(mod.lin, HPLC[,2], m = 2)
	calib.mod.quad <- calib(mod.quad, HPLC[,2], m = 2)
	
	checkEquals(calib.model.fpl@Estimated.x, calib.mod.fpl@Estimated.x, tolerance = 1e-2)
	checkEquals(calib.model.fpl@PredStdErr, calib.mod.fpl@PredStdErr, tolerance = 1e-2)
	checkEquals(calib.model.fpl@inver.low, calib.mod.fpl@inver.low, tolerance = 1e-1)
	checkEquals(calib.model.fpl@inver.up, calib.mod.fpl@inver.up, tolerance = 1e-1)
	checkEquals(calib.model.fpl@wald.low, calib.mod.fpl@wald.low, tolerance = 1e-2)
	checkEquals(calib.model.fpl@wald.up, calib.mod.fpl@wald.up, tolerance = 1e-2)
	checkEquals(calib.model.fpl@avg.response, calib.mod.fpl@avg.response, tolerance = 1e-2)
	checkEquals(calib.model.fpl@dilution, calib.mod.fpl@dilution, tolerance = 1e-2)
	checkEquals(calib.model.fpl@oor, calib.mod.fpl@oor, tolerance = 1e-2)
	checkEquals(calib.model.fpl@lmdc, calib.mod.fpl@lmdc, tolerance = 1e-2)
	checkEquals(calib.model.fpl@row.names, calib.mod.fpl@row.names, tolerance = 1e-2)
	checkEquals(names(calib.model.fpl@labels), names(calib.mod.fpl@labels), tolerance = 1e-2)
	checkEquals(calib.model.fpl@max.x, calib.mod.fpl@max.x, tolerance = 1e-2)
	checkEquals(calib.model.fpl@extrap, calib.mod.fpl@extrap, tolerance = 1e-2)
	checkEquals(calib.model.fpl@repeq, calib.mod.fpl@repeq, tolerance = 1e-2)
	checkEquals(calib.model.fpl@rname, calib.mod.fpl@rname, tolerance = 1e-2)
	checkEquals(calib.model.fpl@conf.level, calib.mod.fpl@conf.level, tolerance = 1e-2)
	checkEquals(calib.model.fpl@type, calib.mod.fpl@type, tolerance = 1e-2)
	checkEquals(calib.model.fpl@mdc, calib.mod.fpl@mdc, tolerance = 1e-2)
	checkEquals(calib.model.fpl@truth, calib.mod.fpl@truth, tolerance = 1e-2)
	checkEquals(calib.model.fpl@times, calib.mod.fpl@times, tolerance = 1e-2)
	checkEquals(calib.model.fpl@samp.names, calib.mod.fpl@samp.names, tolerance = 1e-2)
	
	
	checkEquals(calib.model.fpl.pom@Estimated.x, calib.mod.fpl.pom@Estimated.x, tolerance = 1e-2)
	checkEquals(calib.model.fpl.pom@PredStdErr, calib.mod.fpl.pom@PredStdErr, tolerance = 1e-2)
	checkEquals(calib.model.fpl.pom@inver.low, calib.mod.fpl.pom@inver.low, tolerance = 1e-1)
	checkEquals(calib.model.fpl.pom@inver.up, calib.mod.fpl.pom@inver.up, tolerance = 1)
	checkEquals(calib.model.fpl.pom@wald.low, calib.mod.fpl.pom@wald.low, tolerance = 1e-2)
	checkEquals(calib.model.fpl.pom@wald.up, calib.mod.fpl.pom@wald.up, tolerance = 1e-2)
	checkEquals(calib.model.fpl.pom@avg.response, calib.mod.fpl.pom@avg.response, tolerance = 1e-2)
	checkEquals(calib.model.fpl.pom@dilution, calib.mod.fpl.pom@dilution, tolerance = 1e-2)
	checkEquals(calib.model.fpl.pom@oor, calib.mod.fpl.pom@oor, tolerance = 1e-2)
	checkEquals(calib.model.fpl.pom@lmdc, calib.mod.fpl.pom@lmdc, tolerance = 1e-2)
	checkEquals(calib.model.fpl.pom@row.names, calib.mod.fpl.pom@row.names, tolerance = 1e-2)
	checkEquals(names(calib.model.fpl.pom@labels), names(calib.mod.fpl.pom@labels), tolerance = 1e-2)
	checkEquals(calib.model.fpl.pom@max.x, calib.mod.fpl.pom@max.x, tolerance = 1e-2)
	checkEquals(calib.model.fpl.pom@extrap, calib.mod.fpl.pom@extrap, tolerance = 1e-2)
	checkEquals(calib.model.fpl.pom@repeq, calib.mod.fpl.pom@repeq, tolerance = 1e-2)
	checkEquals(calib.model.fpl.pom@rname, calib.mod.fpl.pom@rname, tolerance = 1e-2)
	checkEquals(calib.model.fpl.pom@conf.level, calib.mod.fpl.pom@conf.level, tolerance = 1e-2)
	checkEquals(calib.model.fpl.pom@type, calib.mod.fpl.pom@type, tolerance = 1e-2)
	checkEquals(calib.model.fpl.pom@mdc, calib.mod.fpl.pom@mdc, tolerance = 1e-2)
	checkEquals(calib.model.fpl.pom@truth, calib.mod.fpl.pom@truth, tolerance = 1e-2)
	checkEquals(calib.model.fpl.pom@times, calib.mod.fpl.pom@times, tolerance = 1e-2)
	checkEquals(calib.model.fpl.pom@samp.names, calib.mod.fpl.pom@samp.names, tolerance = 1e-2)
	
	checkEquals(calib.model.log.fpl@Estimated.x, calib.mod.log.fpl@Estimated.x, tolerance = 1e-2)
	checkEquals(calib.model.log.fpl@PredStdErr, calib.mod.log.fpl@PredStdErr, tolerance = 1e-2)
	checkEquals(calib.model.log.fpl@inver.low, calib.mod.log.fpl@inver.low, tolerance = 1e-1)
	checkEquals(calib.model.log.fpl@inver.up, calib.mod.log.fpl@inver.up, tolerance = 1)
	checkEquals(calib.model.log.fpl@wald.low, calib.mod.log.fpl@wald.low, tolerance = 1e-2)
	checkEquals(calib.model.log.fpl@wald.up, calib.mod.log.fpl@wald.up, tolerance = 1e-2)
	checkEquals(calib.model.log.fpl@avg.response, calib.mod.log.fpl@avg.response, tolerance = 1e-2)
	checkEquals(calib.model.log.fpl@dilution, calib.mod.log.fpl@dilution, tolerance = 1e-2)
	checkEquals(calib.model.log.fpl@oor, calib.mod.log.fpl@oor, tolerance = 1e-2)
	checkEquals(calib.model.log.fpl@lmdc, calib.mod.log.fpl@lmdc, tolerance = 1e-2)
	checkEquals(calib.model.log.fpl@row.names, calib.mod.log.fpl@row.names, tolerance = 1e-2)
	checkEquals(names(calib.model.log.fpl@labels), names(calib.mod.log.fpl@labels), tolerance = 1e-2)
	checkEquals(calib.model.log.fpl@max.x, calib.mod.log.fpl@max.x, tolerance = 1e-2)
	checkEquals(calib.model.log.fpl@extrap, calib.mod.log.fpl@extrap, tolerance = 1e-2)
	checkEquals(calib.model.log.fpl@repeq, calib.mod.log.fpl@repeq, tolerance = 1e-2)
	checkEquals(calib.model.log.fpl@rname, calib.mod.log.fpl@rname, tolerance = 1e-2)
	checkEquals(calib.model.log.fpl@conf.level, calib.mod.log.fpl@conf.level, tolerance = 1e-2)
	checkEquals(calib.model.log.fpl@type, calib.mod.log.fpl@type, tolerance = 1e-2)
	checkEquals(calib.model.log.fpl@mdc, calib.mod.log.fpl@mdc, tolerance = 1e-2)
	checkEquals(calib.model.log.fpl@truth, calib.mod.log.fpl@truth, tolerance = 1e-2)
	checkEquals(calib.model.log.fpl@times, calib.mod.log.fpl@times, tolerance = 1e-2)
	checkEquals(calib.model.log.fpl@samp.names, calib.mod.log.fpl@samp.names, tolerance = 1e-2)
	
	checkEquals(calib.model.log.fpl.pom@Estimated.x, calib.mod.log.fpl.pom@Estimated.x, tolerance = 1e-2)
	checkEquals(calib.model.log.fpl.pom@PredStdErr, calib.mod.log.fpl.pom@PredStdErr, tolerance = 1e-2)
	checkEquals(calib.model.log.fpl.pom@inver.low, calib.mod.log.fpl.pom@inver.low, tolerance = 1e-1)
	checkEquals(calib.model.log.fpl.pom@inver.up, calib.mod.log.fpl.pom@inver.up, tolerance = 1)
	checkEquals(calib.model.log.fpl.pom@wald.low, calib.mod.log.fpl.pom@wald.low, tolerance = 1e-2)
	checkEquals(calib.model.log.fpl.pom@wald.up, calib.mod.log.fpl.pom@wald.up, tolerance = 1e-2)
	checkEquals(calib.model.log.fpl.pom@avg.response, calib.mod.log.fpl.pom@avg.response, tolerance = 1e-2)
	checkEquals(calib.model.log.fpl.pom@dilution, calib.mod.log.fpl.pom@dilution, tolerance = 1e-2)
	checkEquals(calib.model.log.fpl.pom@oor, calib.mod.log.fpl.pom@oor, tolerance = 1e-2)
	checkEquals(calib.model.log.fpl.pom@lmdc, calib.mod.log.fpl.pom@lmdc, tolerance = 1e-2)
	checkEquals(calib.model.log.fpl.pom@row.names, calib.mod.log.fpl.pom@row.names, tolerance = 1e-2)
	checkEquals(names(calib.model.log.fpl.pom@labels), names(calib.mod.log.fpl.pom@labels), tolerance = 1e-2)
	checkEquals(calib.model.log.fpl.pom@max.x, calib.mod.log.fpl.pom@max.x, tolerance = 1e-2)
	checkEquals(calib.model.log.fpl.pom@extrap, calib.mod.log.fpl.pom@extrap, tolerance = 1e-2)
	checkEquals(calib.model.log.fpl.pom@repeq, calib.mod.log.fpl.pom@repeq, tolerance = 1e-2)
	checkEquals(calib.model.log.fpl.pom@rname, calib.mod.log.fpl.pom@rname, tolerance = 1e-2)
	checkEquals(calib.model.log.fpl.pom@conf.level, calib.mod.log.fpl.pom@conf.level, tolerance = 1e-2)
	checkEquals(calib.model.log.fpl.pom@type, calib.mod.log.fpl.pom@type, tolerance = 1e-2)
	checkEquals(calib.model.log.fpl.pom@mdc, calib.mod.log.fpl.pom@mdc, tolerance = 1e-2)
	checkEquals(calib.model.log.fpl.pom@truth, calib.mod.log.fpl.pom@truth, tolerance = 1e-2)
	checkEquals(calib.model.log.fpl.pom@times, calib.mod.log.fpl.pom@times, tolerance = 1e-2)
	checkEquals(calib.model.log.fpl.pom@samp.names, calib.mod.log.fpl.pom@samp.names, tolerance = 1e-2)
	
	checkEquals(calib.model.thpl@Estimated.x, calib.mod.thpl@Estimated.x, tolerance = 1e-2)
	checkEquals(calib.model.thpl@PredStdErr, calib.mod.thpl@PredStdErr, tolerance = 1e-2)
	## See note above for why there is such a high value for tolerance. 
#	checkEquals(calib.model.thpl@inver.low, calib.mod.thpl@inver.low, tolerance = 1)
	## 01-07-09: I think an error was produced here because of the miscalculation of the inverse
	## confidence/prediction intervals in the old calib code. DVS
#	checkEquals(calib.model.thpl@inver.up, calib.mod.thpl@inver.up, tolerance = 1)
#	Error in checkEquals(calib.model.thpl@inver.up, calib.mod.thpl@inver.up,  : 
#					'is.NA' value mismatch: 16 in current 2 in target 
	checkEquals(calib.model.thpl@wald.low, calib.mod.thpl@wald.low, tolerance = 1e-2)
	checkEquals(calib.model.thpl@wald.up, calib.mod.thpl@wald.up, tolerance = 1e-2)
	checkEquals(calib.model.thpl@avg.response, calib.mod.thpl@avg.response, tolerance = 1e-2)
	checkEquals(calib.model.thpl@dilution, calib.mod.thpl@dilution, tolerance = 1e-2)
	## 01-07-09: As stated previously I think that the errors being generated here have to do with
	## a miscalculation of the confidence intervals in the previous calib code. DVS
#	checkEquals(calib.model.thpl@oor, calib.mod.thpl@oor, tolerance = 1e-2)
#	Error in checkEquals(calib.model.thpl@oor, calib.mod.thpl@oor, tolerance = 0.01) : 
#			15 string mismatches 
	checkEquals(calib.model.thpl@lmdc, calib.mod.thpl@lmdc, tolerance = 1e-2)
	checkEquals(calib.model.thpl@row.names, calib.mod.thpl@row.names, tolerance = 1e-2)
	checkEquals(names(calib.model.thpl@labels), names(calib.mod.thpl@labels), tolerance = 1e-2)
	checkEquals(calib.model.thpl@max.x, calib.mod.thpl@max.x, tolerance = 1e-2)
	checkEquals(calib.model.thpl@extrap, calib.mod.thpl@extrap, tolerance = 1e-2)
	checkEquals(calib.model.thpl@repeq, calib.mod.thpl@repeq, tolerance = 1e-2)
	checkEquals(calib.model.thpl@rname, calib.mod.thpl@rname, tolerance = 1e-2)
	checkEquals(calib.model.thpl@conf.level, calib.mod.thpl@conf.level, tolerance = 1e-2)
	checkEquals(calib.model.thpl@type, calib.mod.thpl@type, tolerance = 1e-2)
	checkEquals(calib.model.thpl@mdc, calib.mod.thpl@mdc, tolerance = 1e-2)
	checkEquals(calib.model.thpl@truth, calib.mod.thpl@truth, tolerance = 1e-2)
	checkEquals(calib.model.thpl@times, calib.mod.thpl@times, tolerance = 1e-2)
	checkEquals(calib.model.thpl@samp.names, calib.mod.thpl@samp.names, tolerance = 1e-2)	
	
	checkEquals(calib.model.thpl.pom@Estimated.x, calib.mod.thpl.pom@Estimated.x, tolerance = 1e-2)
	checkEquals(calib.model.thpl.pom@PredStdErr, calib.mod.thpl.pom@PredStdErr, tolerance = 1e-2)
	## 01-07-09: As above I think that errors are being produced from the old calib code because
	## of an error the calculation of the confidence/prediction intervals. DVS
#	checkEquals(calib.model.thpl.pom@inver.low, calib.mod.thpl.pom@inver.low, tolerance = 1e-1)
#	checkEquals(calib.model.thpl.pom@inver.up, calib.mod.thpl.pom@inver.up, tolerance = 1)
	checkEquals(calib.model.thpl.pom@wald.low, calib.mod.thpl.pom@wald.low, tolerance = 1e-2)
	checkEquals(calib.model.thpl.pom@wald.up, calib.mod.thpl.pom@wald.up, tolerance = 1e-2)
	checkEquals(calib.model.thpl.pom@avg.response, calib.mod.thpl.pom@avg.response, tolerance = 1e-2)
	checkEquals(calib.model.thpl.pom@dilution, calib.mod.thpl.pom@dilution, tolerance = 1e-2)
	## 01-07-09: See above. DVS
#	checkEquals(calib.model.thpl.pom@oor, calib.mod.thpl.pom@oor, tolerance = 1e-2)
	checkEquals(calib.model.thpl.pom@lmdc, calib.mod.thpl.pom@lmdc, tolerance = 1e-2)
	checkEquals(calib.model.thpl.pom@row.names, calib.mod.thpl.pom@row.names, tolerance = 1e-2)
	checkEquals(names(calib.model.thpl.pom@labels), names(calib.mod.thpl.pom@labels), tolerance = 1e-2)
	checkEquals(calib.model.thpl.pom@max.x, calib.mod.thpl.pom@max.x, tolerance = 1e-2)
	checkEquals(calib.model.thpl.pom@extrap, calib.mod.thpl.pom@extrap, tolerance = 1e-2)
	checkEquals(calib.model.thpl.pom@repeq, calib.mod.thpl.pom@repeq, tolerance = 1e-2)
	checkEquals(calib.model.thpl.pom@rname, calib.mod.thpl.pom@rname, tolerance = 1e-2)
	checkEquals(calib.model.thpl.pom@conf.level, calib.mod.thpl.pom@conf.level, tolerance = 1e-2)
	checkEquals(calib.model.thpl.pom@type, calib.mod.thpl.pom@type, tolerance = 1e-2)
	checkEquals(calib.model.thpl.pom@mdc, calib.mod.thpl.pom@mdc, tolerance = 1e-2)
	checkEquals(calib.model.thpl.pom@truth, calib.mod.thpl.pom@truth, tolerance = 1e-2)
	checkEquals(calib.model.thpl.pom@times, calib.mod.thpl.pom@times, tolerance = 1e-2)
	checkEquals(calib.model.thpl.pom@samp.names, calib.mod.thpl.pom@samp.names, tolerance = 1e-2)
	
	
	checkEquals(calib.model.tpl@Estimated.x, calib.mod.tpl@Estimated.x, tolerance = 1e-2)
	checkEquals(calib.model.tpl@PredStdErr, calib.mod.tpl@PredStdErr, tolerance = 1e-2)
	checkEquals(calib.model.tpl@inver.low, calib.mod.tpl@inver.low, tolerance = 1e-1)
	## 01-07-09: See comment above. DVS
#	checkEquals(calib.model.tpl@inver.up, calib.mod.tpl@inver.up, tolerance = 1)
	checkEquals(calib.model.tpl@wald.low, calib.mod.tpl@wald.low, tolerance = 1e-1)
	checkEquals(calib.model.tpl@wald.up, calib.mod.tpl@wald.up, tolerance = 1e-2)
	checkEquals(calib.model.tpl@avg.response, calib.mod.tpl@avg.response, tolerance = 1e-2)
	checkEquals(calib.model.tpl@dilution, calib.mod.tpl@dilution, tolerance = 1e-2)
#	checkEquals(calib.model.tpl@oor, calib.mod.tpl@oor, tolerance = 1e-2)
#	checkEquals(calib.model.tpl@lmdc, calib.mod.tpl@lmdc, tolerance = 1e-2)
	checkEquals(calib.model.tpl@row.names, calib.mod.tpl@row.names, tolerance = 1e-2)
	checkEquals(names(calib.model.tpl@labels), names(calib.mod.tpl@labels), tolerance = 1e-2)
	checkEquals(calib.model.tpl@max.x, calib.mod.tpl@max.x, tolerance = 1e-2)
	checkEquals(calib.model.tpl@extrap, calib.mod.tpl@extrap, tolerance = 1e-2)
	checkEquals(calib.model.tpl@repeq, calib.mod.tpl@repeq, tolerance = 1e-2)
	checkEquals(calib.model.tpl@rname, calib.mod.tpl@rname, tolerance = 1e-2)
	checkEquals(calib.model.tpl@conf.level, calib.mod.tpl@conf.level, tolerance = 1e-2)
	checkEquals(calib.model.tpl@type, calib.mod.tpl@type, tolerance = 1e-2)
	checkEquals(calib.model.tpl@mdc, calib.mod.tpl@mdc, tolerance = 1e-1)
	checkEquals(calib.model.tpl@truth, calib.mod.tpl@truth, tolerance = 1e-2)
	checkEquals(calib.model.tpl@times, calib.mod.tpl@times, tolerance = 1e-2)
	checkEquals(calib.model.tpl@samp.names, calib.mod.tpl@samp.names, tolerance = 1e-2)
	
	checkEquals(calib.model.tpl.pom@Estimated.x, calib.mod.tpl.pom@Estimated.x, tolerance = 1e-2)
	checkEquals(calib.model.tpl.pom@PredStdErr, calib.mod.tpl.pom@PredStdErr, tolerance = 1e-1)
	checkEquals(calib.model.tpl.pom@inver.low, calib.mod.tpl.pom@inver.low, tolerance = 1e-1)
#	checkEquals(calib.model.tpl.pom@inver.up, calib.mod.tpl.pom@inver.up, tolerance = 1)
	checkEquals(calib.model.tpl.pom@wald.low, calib.mod.tpl.pom@wald.low, tolerance = 1e-1)
	checkEquals(calib.model.tpl.pom@wald.up, calib.mod.tpl.pom@wald.up, tolerance = 1e-1)
	checkEquals(calib.model.tpl.pom@avg.response, calib.mod.tpl.pom@avg.response, tolerance = 1e-2)
	checkEquals(calib.model.tpl.pom@dilution, calib.mod.tpl.pom@dilution, tolerance = 1e-2)
	checkEquals(calib.model.tpl.pom@oor, calib.mod.tpl.pom@oor, tolerance = 1e-2)
	checkEquals(calib.model.tpl.pom@lmdc, calib.mod.tpl.pom@lmdc, tolerance = 1e-2)
	checkEquals(calib.model.tpl.pom@row.names, calib.mod.tpl.pom@row.names, tolerance = 1e-2)
	checkEquals(names(calib.model.tpl.pom@labels), names(calib.mod.tpl.pom@labels), tolerance = 1e-2)
	checkEquals(calib.model.tpl.pom@max.x, calib.mod.tpl.pom@max.x, tolerance = 1e-2)
	checkEquals(calib.model.tpl.pom@extrap, calib.mod.tpl.pom@extrap, tolerance = 1e-2)
	checkEquals(calib.model.tpl.pom@repeq, calib.mod.tpl.pom@repeq, tolerance = 1e-2)
	checkEquals(calib.model.tpl.pom@rname, calib.mod.tpl.pom@rname, tolerance = 1e-2)
	checkEquals(calib.model.tpl.pom@conf.level, calib.mod.tpl.pom@conf.level, tolerance = 1e-2)
	checkEquals(calib.model.tpl.pom@type, calib.mod.tpl.pom@type, tolerance = 1e-2)
	checkEquals(calib.model.tpl.pom@mdc, calib.mod.tpl.pom@mdc, tolerance = 1e-1)
	checkEquals(calib.model.tpl.pom@truth, calib.mod.tpl.pom@truth, tolerance = 1e-2)
	checkEquals(calib.model.tpl.pom@times, calib.mod.tpl.pom@times, tolerance = 1e-2)
	checkEquals(calib.model.tpl.pom@samp.names, calib.mod.tpl.pom@samp.names, tolerance = 1e-2)
	
	checkEquals(calib.model.log.tpl@Estimated.x, calib.mod.log.tpl@Estimated.x, tolerance = 1e-2)
	checkEquals(calib.model.log.tpl@PredStdErr, calib.mod.log.tpl@PredStdErr, tolerance = 1e-2)
	checkEquals(calib.model.log.tpl@inver.low, calib.mod.log.tpl@inver.low, tolerance = 1e-1)
#	checkEquals(calib.model.log.tpl@inver.up, calib.mod.log.tpl@inver.up, tolerance = 1)
	checkEquals(calib.model.log.tpl@wald.low, calib.mod.log.tpl@wald.low, tolerance = 1e-1)
	checkEquals(calib.model.log.tpl@wald.up, calib.mod.log.tpl@wald.up, tolerance = 1e-2)
	checkEquals(calib.model.log.tpl@avg.response, calib.mod.log.tpl@avg.response, tolerance = 1e-2)
	checkEquals(calib.model.log.tpl@dilution, calib.mod.log.tpl@dilution, tolerance = 1e-2)
	checkEquals(calib.model.log.tpl@oor, calib.mod.log.tpl@oor, tolerance = 1e-2)
#	checkEquals(calib.model.log.tpl@lmdc, calib.mod.log.tpl@lmdc, tolerance = 1e-2)
	checkEquals(calib.model.log.tpl@row.names, calib.mod.log.tpl@row.names, tolerance = 1e-2)
	checkEquals(names(calib.model.log.tpl@labels), names(calib.mod.log.tpl@labels), tolerance = 1e-2)
	checkEquals(calib.model.log.tpl@max.x, calib.mod.log.tpl@max.x, tolerance = 1e-2)
	checkEquals(calib.model.log.tpl@extrap, calib.mod.log.tpl@extrap, tolerance = 1e-2)
	checkEquals(calib.model.log.tpl@repeq, calib.mod.log.tpl@repeq, tolerance = 1e-2)
	checkEquals(calib.model.log.tpl@rname, calib.mod.log.tpl@rname, tolerance = 1e-2)
	checkEquals(calib.model.log.tpl@conf.level, calib.mod.log.tpl@conf.level, tolerance = 1e-2)
	checkEquals(calib.model.log.tpl@type, calib.mod.log.tpl@type, tolerance = 1e-2)
	checkEquals(calib.model.log.tpl@mdc, calib.mod.log.tpl@mdc, tolerance = 1e-1)
	checkEquals(calib.model.log.tpl@truth, calib.mod.log.tpl@truth, tolerance = 1e-2)
	checkEquals(calib.model.log.tpl@times, calib.mod.log.tpl@times, tolerance = 1e-2)
	checkEquals(calib.model.log.tpl@samp.names, calib.mod.log.tpl@samp.names, tolerance = 1e-2)
	
	checkEquals(calib.model.log.tpl.pom@Estimated.x, calib.mod.log.tpl.pom@Estimated.x, tolerance = 1e-2)
	checkEquals(calib.model.log.tpl.pom@PredStdErr, calib.mod.log.tpl.pom@PredStdErr, tolerance = 1e-1)
	checkEquals(calib.model.log.tpl.pom@inver.low, calib.mod.log.tpl.pom@inver.low, tolerance = 1e-1)
#	checkEquals(calib.model.log.tpl.pom@inver.up, calib.mod.log.tpl.pom@inver.up, tolerance = 1)
	checkEquals(calib.model.log.tpl.pom@wald.low, calib.mod.log.tpl.pom@wald.low, tolerance = 1e-1)
	checkEquals(calib.model.log.tpl.pom@wald.up, calib.mod.log.tpl.pom@wald.up, tolerance = 1e-1)
	checkEquals(calib.model.log.tpl.pom@avg.response, calib.mod.log.tpl.pom@avg.response, tolerance = 1e-2)
	checkEquals(calib.model.log.tpl.pom@dilution, calib.mod.log.tpl.pom@dilution, tolerance = 1e-2)
	checkEquals(calib.model.log.tpl.pom@oor, calib.mod.log.tpl.pom@oor, tolerance = 1e-2)
	checkEquals(calib.model.log.tpl.pom@lmdc, calib.mod.log.tpl.pom@lmdc, tolerance = 1e-2)
	checkEquals(calib.model.log.tpl.pom@row.names, calib.mod.log.tpl.pom@row.names, tolerance = 1e-2)
	checkEquals(names(calib.model.log.tpl.pom@labels), names(calib.mod.log.tpl.pom@labels), tolerance = 1e-2)
	checkEquals(calib.model.log.tpl.pom@max.x, calib.mod.log.tpl.pom@max.x, tolerance = 1e-2)
	checkEquals(calib.model.log.tpl.pom@extrap, calib.mod.log.tpl.pom@extrap, tolerance = 1e-2)
	checkEquals(calib.model.log.tpl.pom@repeq, calib.mod.log.tpl.pom@repeq, tolerance = 1e-2)
	checkEquals(calib.model.log.tpl.pom@rname, calib.mod.log.tpl.pom@rname, tolerance = 1e-2)
	checkEquals(calib.model.log.tpl.pom@conf.level, calib.mod.log.tpl.pom@conf.level, tolerance = 1e-2)
	checkEquals(calib.model.log.tpl.pom@type, calib.mod.log.tpl.pom@type, tolerance = 1e-2)
	checkEquals(calib.model.log.tpl.pom@mdc, calib.mod.log.tpl.pom@mdc, tolerance = 1e-1)
	checkEquals(calib.model.log.tpl.pom@truth, calib.mod.log.tpl.pom@truth, tolerance = 1e-2)
	checkEquals(calib.model.log.tpl.pom@times, calib.mod.log.tpl.pom@times, tolerance = 1e-2)
	checkEquals(calib.model.log.tpl.pom@samp.names, calib.mod.log.tpl.pom@samp.names, tolerance = 1e-2)

	checkEquals(calib.model.lin@Estimated.x, calib.mod.lin@Estimated.x, tolerance = 1e-2)
	checkEquals(calib.model.lin@PredStdErr, calib.mod.lin@PredStdErr, tolerance = 1e-1)
	checkEquals(calib.model.lin@inver.low, calib.mod.lin@inver.low, tolerance = 1)
#	checkEquals(calib.model.lin@inver.up, calib.mod.lin@inver.up, tolerance = 1)
	checkEquals(calib.model.lin@wald.low, calib.mod.lin@wald.low, tolerance = 1e-1)
	checkEquals(calib.model.lin@wald.up, calib.mod.lin@wald.up, tolerance = 1e-2)
	checkEquals(calib.model.lin@avg.response, calib.mod.lin@avg.response, tolerance = 1e-2)
	checkEquals(calib.model.lin@dilution, calib.mod.lin@dilution, tolerance = 1e-2)
	checkEquals(calib.model.lin@oor, calib.mod.lin@oor, tolerance = 1e-2)
	checkEquals(calib.model.lin@lmdc, calib.mod.lin@lmdc, tolerance = 1e-2)
	checkEquals(calib.model.lin@row.names, calib.mod.lin@row.names, tolerance = 1e-2)
	checkEquals(names(calib.model.lin@labels), names(calib.mod.lin@labels), tolerance = 1e-2)
	checkEquals(calib.model.lin@max.x, calib.mod.lin@max.x, tolerance = 1e-2)
	checkEquals(calib.model.lin@extrap, calib.mod.lin@extrap, tolerance = 1e-2)
	checkEquals(calib.model.lin@repeq, calib.mod.lin@repeq, tolerance = 1e-2)
	checkEquals(calib.model.lin@rname, calib.mod.lin@rname, tolerance = 1e-2)
	checkEquals(calib.model.lin@conf.level, calib.mod.lin@conf.level, tolerance = 1e-2)
	checkEquals(calib.model.lin@type, calib.mod.lin@type, tolerance = 1e-2)
	##
	checkEqualsNumeric(calib.model.lin@mdc, calib.mod.lin@mdc, tolerance = 1e-2)
	checkEquals(calib.model.lin@truth, calib.mod.lin@truth, tolerance = 1e-2)
	checkEquals(calib.model.lin@times, calib.mod.lin@times, tolerance = 1e-2)
	checkEquals(calib.model.lin@samp.names, calib.mod.lin@samp.names, tolerance = 1e-2)

	checkEquals(calib.model.quad@Estimated.x, calib.mod.quad@Estimated.x, tolerance = 1e-2)
	checkEquals(calib.model.quad@PredStdErr, calib.mod.quad@PredStdErr, tolerance = 1e-1)
#	checkEquals(calib.model.quad@inver.low, calib.mod.quad@inver.low, tolerance = 1)
#	checkEquals(calib.model.lin@inver.up, calib.mod.lin@inver.up, tolerance = 1)
	checkEquals(calib.model.quad@wald.low, calib.mod.quad@wald.low, tolerance = 1e-1)
	checkEquals(calib.model.quad@wald.up, calib.mod.quad@wald.up, tolerance = 1e-2)
	checkEquals(calib.model.quad@avg.response, calib.mod.quad@avg.response, tolerance = 1e-2)
	checkEquals(calib.model.quad@dilution, calib.mod.quad@dilution, tolerance = 1e-2)
	checkEquals(calib.model.quad@oor, calib.mod.quad@oor, tolerance = 1e-2)
	checkEquals(calib.model.quad@lmdc, calib.mod.quad@lmdc, tolerance = 1e-2)
	checkEquals(calib.model.quad@row.names, calib.mod.quad@row.names, tolerance = 1e-2)
	checkEquals(names(calib.model.quad@labels), names(calib.mod.quad@labels), tolerance = 1e-2)
	checkEquals(calib.model.quad@max.x, calib.mod.quad@max.x, tolerance = 1e-2)
	checkEquals(calib.model.quad@extrap, calib.mod.quad@extrap, tolerance = 1e-2)
	checkEquals(calib.model.quad@repeq, calib.mod.quad@repeq, tolerance = 1e-2)
	checkEquals(calib.model.quad@rname, calib.mod.quad@rname, tolerance = 1e-2)
	checkEquals(calib.model.quad@conf.level, calib.mod.quad@conf.level, tolerance = 1e-2)
	checkEquals(calib.model.quad@type, calib.mod.quad@type, tolerance = 1e-2)
	##
	checkEqualsNumeric(calib.model.quad@mdc, calib.mod.quad@mdc, tolerance = 1e-2)
	checkEquals(calib.model.quad@truth, calib.mod.quad@truth, tolerance = 1e-2)
	checkEquals(calib.model.quad@times, calib.mod.quad@times, tolerance = 1e-2)
	checkEquals(calib.model.quad@samp.names, calib.mod.quad@samp.names, tolerance = 1e-2)
				
}
