% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calib_blr.R
\name{calib_blr}
\alias{calib_blr}
\title{Estimate calibration curves for a multistate model using binary logistic regression calibration techniques and inverse probability of censoring weights.'}
\usage{
calib_blr(
  data.mstate,
  data.raw,
  j,
  s,
  t,
  tp.pred,
  curve.type = "rcs",
  rcs.nk = 3,
  loess.span = 0.75,
  loess.degree = 2,
  weights = NULL,
  w.function = NULL,
  w.covs = NULL,
  w.landmark.type = "state",
  w.max = 10,
  w.stabilised = FALSE,
  w.max.follow = NULL,
  CI = FALSE,
  CI.type = "bootstrap",
  CI.R.boot = NULL,
  data.pred.plot = NULL,
  transitions.out = NULL,
  ...
)
}
\arguments{
\item{data.mstate}{Validation data in \code{msdata} format}

\item{data.raw}{Validation data in \code{data.frame} (one row per individual)}

\item{j}{Landmark state at which predictions were made}

\item{s}{Landmark time at which predictions were made}

\item{t}{Follow up time at which calibration is to be assessed}

\item{tp.pred}{Matrix of predicted transition probabilities at time t, if in state j at time s. There must be a seperate column for the predicted transition probabilities into every state, even if these predicted transition probabilities are 0.}

\item{curve.type}{Whether calibration curves are estimated using restricted cubic splines ('rcs') or loess smoothers ('loess')}

\item{rcs.nk}{Number of knots when curves are estimated using restricted cubic splines}

\item{loess.span}{Span when curves are estimated using loess smoothers}

\item{loess.degree}{Degree when curves are estimated. using loess smoothers}

\item{weights}{Vector of inverse probability of censoring weights}

\item{w.function}{Custom function for estimating the inverse probability of censoring weights}

\item{w.covs}{Character vector of variable names to adjust for when calculating inverse probability of censoring weights}

\item{w.landmark.type}{Whether weights are estimated in all individuals uncensored at time s ('all') or only in individuals uncensored and in state j at time s ('state')}

\item{w.max}{Maximum bound for inverse probability of censoring weights}

\item{w.stabilised}{Indicates whether inverse probability of censoring weights should be stabilised or not}

\item{w.max.follow}{Maximum follow up for model calculating inverse probability of censoring weights. Reducing this to \code{t} + 1 may aid in the proportional hazards assumption being met in this model.}

\item{CI}{Size of confidence intervals as a \%}

\item{CI.type}{Method for estimating confidence interval (currently restricted to \code{bootstrap})}

\item{CI.R.boot}{Number of bootstrap replicates when estimating the confidence interval for the calibration curve}

\item{data.pred.plot}{Data frame or matrix of predicted risks for each possible transition over which to plot the calibration curves. Must have one column for every possible transition.}

\item{transitions.out}{Transitions for which to calculate calibration curves. Will do all possible transitions if left as NULL.}

\item{...}{Extra arguments to be passed to w.function (custom function for estimating weights)}
}
\value{
\code{\link{calib_blr}} returns a list containing two elements:
\code{plotdata} and \code{metadata}. The \code{plotdata} element contains the
data for the calibration curves. This will itself be a list with each element
containing calibration plot data for the transition probabilities into each of the possible
states. Each list element contains patient ids (\code{id}) from \code{data.raw}, the predicted
transition probabilities (\code{pred}) and the estimated observed event
probabilities (\code{obs}). If a confidence interval is requested, upper (\code{obs.upper})
and lower (\code{obs.lower}) bounds for the observed event probabilities are also returned.
If data.pred.plot is defined manually, column (\code{id}) is not returned.
The \code{metadata} element contains metadata including: a vector of the possible transitions,
a vector of which transitions calibration curves have been estimated for, the
size of the confidence interval, the method for estimating the calibration curve
and other user specified information.
}
\description{
Creates the underlying data for the calibration curves. \code{calib_blr}
estimates the observed event probabilities for a given set of predicted transition probabilities
in a cohort of interest. This is done using techniques for assessing calibration of binary logistic regression models,
in combination with inverse probability of censoring weights and landmarking.
}
\details{
Observed event probabilities at time \code{t} are estimated for predicted
transition probabilities \code{tp.pred} out of state \code{j} at time \code{s}.
\code{calib_blr} estimates calibration curves using techniques for assessing the calibration of binary logistic
regression models (Van Calster et al., 2016). A choice between restricted cubic splines and loess
smoothers for estimating the calibration curve can be made using \code{curve.type}.
Landmarking is applied to only assess calibration in individuals who are uncensored
and in state \code{j} at time \code{s}. Censoring is dealt with using inverse probability of
censoring weights (Hernan M, Robins J, 2020).

Two datasets for the same cohort of inidividuals must be provided. Firstly \code{data.mstate} must be a dataset of class \code{msdata},
generated using the \code{[mstate]} package. This dataset is used to apply the landmarking. Secondly, \code{data.raw} must be
a \code{data.frame} with one row per individual, containing the desired variables for estimating the weights, and variables for the time
until censoring (\code{dtcens}), and an indicator for censoring \code{dtcens.s}, where (\code{dtcens.s = 1}) if
an individual is censored at time \code{dtcens}, and \code{dtcens.s = 0} otherwise. When an individual
enters an absorbing state, this prevents censoring from happening (i.e. dtcens.s = 0). Unless the user specifies
the weights using \code{weights}, the weights are
estimated using a cox-proportional hazard model, assuming a linear
functional form of the variables defined in \code{w.covs}. We urge users to
specify their own model for estimating the weights. The \code{weights} argument
must be a vector with length equal to the number of rows of \code{data.raw}. Confidence intervals for
the calibration curves can be estimated using bootstrapping. This procedure
uses the internal method for estimating weights, we therefore encourage
users to specify their own bootstrapping procedure, which incorporates their
own model for estimating the weights. Details on how to do this are provided
in the vignette \emph{BLR-IPCW-manual-bootstrap}.

The calibration curves can be plotted using \code{\link{plot.calib_blr}}.
}
\examples{
# Estimate BLR-IPCW calibration curves for the predicted transition
# probabilities at time t = 1826, when predictions were made at time
# s = 0 in state j = 1. These predicted transition probabilities are stored in tps0.

# Extract the predicted transition probabilities out of state j = 1
tp.pred <- dplyr::select(dplyr::filter(tps0, j == 1), any_of(paste("pstate", 1:6, sep = "")))

# Now estimate the observed event probabilities for each possible transition.
# 95\% confidence intervals are estimated using bootstrapping with 200
# bootstrap repicates. In practice we recommend using a higher number.
dat.calib.blr <-
calib_blr(data.mstate = msebmtcal,
 data.raw = ebmtcal,
 j=1,
 s=0,
 t = 1826,
 tp.pred = tp.pred,
 w.covs = c("year", "agecl", "proph", "match"))

# The data for each calibration curve are stored in the "plotdata" list
# element.
str(dat.calib.blr)

}
\references{
Hernan M, Robins J (2020). “12.2 Estimating IP weights via modeling.” In \emph{Causal Inference:
What If}, chapter 12.2. Chapman Hall/CRC, Boca Raton.

Van Calster B, Nieboer D, Vergouwe Y, De Cock B, Pencina MJ, Steyerberg EW (2016). “A
calibration hierarchy for risk models was defined: From utopia to empirical data.” \emph{Journal
of Clinical Epidemiology}, 74, 167–176. ISSN 18785921. doi:10.1016/j.jclinepi.2015.
12.005. URL http://dx.doi.org/10.1016/j.jclinepi.2015.12.005
}
