% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_calib.R
\name{plot.calib_msm}
\alias{plot.calib_msm}
\title{Plots calibration curves estimated using \code{\link{calib_msm}}.}
\usage{
\method{plot}{calib_msm}(
  x,
  ...,
  combine = TRUE,
  ncol = NULL,
  nrow = NULL,
  size.line = 0.5,
  size.text = 12,
  marg.density = FALSE,
  marg.density.size = 5,
  marg.density.type = "density",
  marg.rug = FALSE,
  marg.rug.transparency = 0.1,
  titles.include = TRUE,
  titles = NULL,
  axis.titles.x = NULL,
  axis.titles.text.x = "Predicted risk",
  axis.titles.y = NULL,
  axis.titles.text.y = "Observed risk",
  legend.include = TRUE,
  legend.seperate = FALSE,
  legend.title = NULL,
  legend.position = "bottom"
)
}
\arguments{
\item{x}{Object of class 'calib_msm' generated from \code{\link{calib_msm}}.}

\item{...}{Other}

\item{combine}{Whether to combine into one plot using ggarrange, or return as a list of individual plots}

\item{ncol}{Number of columns for combined calibration plot}

\item{nrow}{Number of rows for combined calibration plot}

\item{size.line}{Size of line plots}

\item{size.text}{Size of text in plot}

\item{marg.density}{Whether to produce marginal density plots TRUE/FALSE}

\item{marg.density.size}{Size of the main plot relative to the density plots (see \code{\link[ggExtra]{ggMarginal}})}

\item{marg.density.type}{What type of marginal plot to show (see \code{\link[ggExtra]{ggMarginal}})}

\item{marg.rug}{Whether to produce marginal rug plots TRUE/FALSE}

\item{marg.rug.transparency}{Degree of transparency for the density rug plot along each axis}

\item{titles.include}{Whether to include titles for each individual calibration plots}

\item{titles}{Vector of titles for the calibration plots. Defaults to "State k" for each plot.}

\item{axis.titles.x}{Position of plots for which to include title on x-axis}

\item{axis.titles.text.x}{x-axis title}

\item{axis.titles.y}{Position of plots for which to include title on y-axis}

\item{axis.titles.text.y}{y-axis title}

\item{legend.include}{Whether to produce a legend}

\item{legend.seperate}{= Whether to include legend in plot (FALSE) or as a seperate object (TRUE)}

\item{legend.title}{Title of legend}

\item{legend.position}{Position of legend}
}
\value{
If \code{combine = TRUE}, returns an object of classes \code{gg}, \code{ggplot}, and \code{ggarrange},
as all ggplots have been combined into one object. If \code{combine = FALSE}, returns an object of
class \code{list}, each element containing an object of class \code{gg} and \code{ggplot}.
}
\description{
Plots calibration curves for the transition probabilities of a multistate model
estimated using BLR-IPCW and pseudo-value approaches.
}
\examples{
# Estimate and plot BLR-IPCW calibration curves for the predicted transition
# probabilities at time t = 1826, when predictions were made at time
# s = 0 in state j = 1. These predicted transition probabilities are stored in tps0.

# Extract the predicted transition probabilities out of state j = 1
tp.pred <- dplyr::select(dplyr::filter(tps0, j == 1), any_of(paste("pstate", 1:6, sep = "")))

# Now estimate the observed event probabilities for each possible transition.
dat.calib <-
calib_msm(data.ms = msebmtcal,
 data.raw = ebmtcal,
 j=1,
 s=0,
 t = 1826,
 tp.pred = tp.pred,
 w.covs = c("year", "agecl", "proph", "match"))

 # These are then plotted
 plot(dat.calib, combine = TRUE, nrow = 2, ncol = 3)

}
