% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expand-abbrev.R
\name{expand_abbrev}
\alias{expand_abbrev}
\title{Expand Abbreviations}
\usage{
expand_abbrev(x, abb = NULL, rep = NULL)
}
\arguments{
\item{x}{A vector containing abbreviations.}

\item{abb}{One of three objects: (1) A dataframe with abbreviations in the
\emph{first} column and corresponding replacement strings in the \emph{second}
column; (2) a \emph{named} vector, with abbreviations as names for their
respective replacements (e.g., \code{c("abb" = "rep")}); or (3) an unnamed
vector of abbreviations with an unnamed vector of replacements in the \code{rep}
argument.}

\item{rep}{If \code{abb} is an unnamed vector, a vector of replacement strings for
each abbreviation in \code{abb}.}
}
\value{
The vector \code{x} with abbreviation replaced with their full version.
}
\description{
Create or use a named vector (\code{c("abb" = "rep")}) and pass it to
\code{\link[stringr:str_replace]{stringr::str_replace_all()}}. The \code{abb} argument is surrounded with \verb{\\\\b}
to capture only isolated abbreviations. To be used inside
\code{\link[=normal_address]{normal_address()}} and \code{\link[=normal_city]{normal_city()}} with \link{usps_street} and \link{usps_city},
respectively.
}
\examples{
expand_abbrev(x = "MT VERNON", abb = c("MT" = "MOUNT"))
expand_abbrev(x = "VT", abb = state.abb, rep = state.name)
expand_abbrev(x = "Low FE Level", abb = tibble::tibble(x = "FE", y = "Iron"))
}
\seealso{
Other geographic normalization functions: 
\code{\link{abbrev_full}()},
\code{\link{abbrev_state}()},
\code{\link{check_city}()},
\code{\link{expand_state}()},
\code{\link{fetch_city}()},
\code{\link{normal_address}()},
\code{\link{normal_city}()},
\code{\link{normal_state}()},
\code{\link{normal_zip}()},
\code{\link{str_normal}()}
}
\concept{geographic normalization functions}
