% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/results_processing.R
\name{VPC}
\alias{VPC}
\title{Compute the VPC summary. Input data frame must contain the following columns:
- replicate: replicate number
- low: low percentile value in replicate (and in scenario if present)
- med: median value in replicate (and in scenario if present)
- up: up percentile value in replicate (and in scenario if present)
- any scenario column}
\usage{
VPC(x, scenarios = NULL, level = 0.9)
}
\arguments{
\item{x}{data frame}

\item{scenarios}{scenarios, character vector, NULL is default}

\item{level}{PI level, default is 0.9 (90\% PI)}
}
\value{
VPC summary with columns TIME, <scenarios> and all combinations of 
low, med, up (i.e. low_low, low_med, low_up, etc.)
}
\description{
Compute the VPC summary. Input data frame must contain the following columns:
- replicate: replicate number
- low: low percentile value in replicate (and in scenario if present)
- med: median value in replicate (and in scenario if present)
- up: up percentile value in replicate (and in scenario if present)
- any scenario column
}
