% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_deployments.R
\name{filter_deployments}
\alias{filter_deployments}
\title{Filter deployments}
\usage{
filter_deployments(x, ...)
}
\arguments{
\item{x}{Camera Trap Data Package object, as returned by
\code{read_camtrapdp()}.}

\item{...}{Filtering conditions, see \code{dplyr::filter()}.}
}
\value{
\code{x} filtered.
}
\description{
Subsets deployments in a Camera Trap Data Package object, retaining all
rows that satisfy the conditions.
}
\details{
\itemize{
\item Media are filtered on associated \code{deploymentID}.
\item Observations are filtered on associated \code{deploymentID}.
}
}
\examples{
x <- example_dataset()

# Filtering returns x, so pipe with deployments() to see the result
x \%>\%
  filter_deployments(deploymentID == "62c200a9") \%>\%
  deployments()

# Filtering on deployments also affects associated media and observations
x_filtered <- filter_deployments(x, deploymentID == "62c200a9")
media(x_filtered)
observations(x_filtered)

# Filtering on multiple conditions (combined with &)
x \%>\%
  filter_deployments(latitude > 51.0, longitude > 5.0) \%>\%
  deployments()

# Filtering on dates is easiest with lubridate
library(lubridate, warn.conflicts = FALSE)
x \%>\%
  filter_deployments(
    deploymentStart >= lubridate::as_date("2020-06-19"),
    deploymentEnd <= lubridate::as_date("2020-08-30")
  ) \%>\%
  deployments()
}
\seealso{
Other filter functions: 
\code{\link{filter_media}()},
\code{\link{filter_observations}()}
}
\concept{filter functions}
