% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cpr_rand_comm.R
\name{cpr_rand_comm}
\alias{cpr_rand_comm}
\title{Randomize a single community matrix}
\usage{
cpr_rand_comm(comm, null_model, n_iterations = 1, thin = 1, seed = NULL)
}
\arguments{
\item{comm}{Dataframe or matrix; input community data with
sites (communities) as rows and species as columns. Values of each cell are
the presence/absence (0 or 1) or number of individuals (abundance) of each
species in each site.}

\item{null_model}{Character vector of length 1 or object of class \code{commsim};
either the name of the model to use for generating random communities (null
model), or a custom null model. For full list of available predefined null
models, see the help file of \code{\link[vegan:commsim]{vegan::commsim()}}, or run
\code{\link[vegan:commsim]{vegan::make.commsim()}}. An object of class \code{commsim} can be generated with
\code{\link[vegan:commsim]{vegan::commsim()}} (see Examples).}

\item{n_iterations}{Numeric vector of length 1; number of iterations for
sequential null models. Ignored by non-sequential null models.}

\item{thin}{Numeric vector of length 1; thinning parameter used by some
null models in \code{vegan} (e.g., \code{quasiswap}); ignored for other models.}

\item{seed}{Integer vector of length 1 or NULL; random seed that will be used
in a call to \code{set.seed()} before randomizing the matrix. Default (\code{NULL})
will not change the random generator state.}
}
\value{
Matrix
}
\description{
Note that binary null models return a binary matrix, even if an abundance
matrix was used as input.
}
\examples{
set.seed(12345)

# Check list of available pre-defined null models in vegan
vegan::make.commsim()

# Binary null model produces binary output
data(phylocom)
cpr_rand_comm(phylocom$comm, "swap", 100)

# Quantitative null model produces quantitative output
cpr_rand_comm(phylocom$comm, "swap_count", 100)

# How to use a custom null model
# 1. Define a randomizing function, e.g. re-sample the matrix while
# preserving total number of presences (same as the "r00" model)
randomizer <- function(x, n, ...) {
  array(replicate(n, sample(x)), c(dim(x), n))
}

# 2. Generate a commsim object
cs_object <- vegan::commsim(
  "r00_model",
  fun = randomizer, binary = TRUE,
  isSeq = FALSE, mode = "integer"
)

# 3. Generate the null community
cpr_rand_comm(phylocom$comm, cs_object, 100)
}
